<?php

namespace App\Console\Commands;

use App\Helpers\AcsHttpRequestHelper;
use App\Models\Apartment;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class SaveLocalApartments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'apartment:generation:save';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Save local apartments to sk server';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $apartments = Apartment::where('is_local', 1)
            ->where('is_save', 1)
            ->take(20)
            ->get();

        if($apartments) {
            foreach ($apartments as $apartment) {
                sleep(0.8);
                $apartment->is_local = 0;
                $apartment->is_save = 0;

                if ($apartment->save()) {
                    $asc_helper = new AcsHttpRequestHelper();
                    $response = $asc_helper->sendPost('/api/apartment', [
                        'object_id' => $apartment->object_id,
                        'ds_id' => $apartment->id,
                        'entrance' => $apartment->entrance,
                        'floor' => $apartment->floor,
                        'number' => $apartment->number,
                        'available_activations_count' => $apartment->activation_limit
                    ]);

                    switch ($response['status']) {
                        case 201:
                            // show a success message
                            Log::info('Apartment id: ' . $apartment->id . ' object_id: ' . trans('backpack::crud.insert_success'));
                            break;
                        default:
                            $apartment->delete();
                            Log::error(__('response_error.' . $response['status']));
                            break;
                    }

                } else {
                    Log::error('Apartment id: ' . $apartment->id . ' object_id: ' . $apartment->id . ' save failed');
                }
            }
        }
    }
}
