<?php

namespace App\Console\Commands\PushSend;

use App\Models\Notice;
use App\Notifications\NewNotice;
use App\Notifications\NewNoticeDefault;
use Carbon\Carbon;

class NewNoticePushSend extends BasePushSend {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'NoticePush:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sending push notifications for new notice';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
        $notice = Notice::where('push_sent', 0)
            ->whereDate('actual_from_date', '<=', Carbon::now())
            ->get();

        foreach ($notice as $model) {

            $notification_default = (new NewNoticeDefault())->setTheme($model->theme);
            $notification = (new NewNotice())->setTheme($model->theme);

            $this->sendToOne($model, $notification, $notification_default);
        }
    }
}
