<?php

namespace App\Console\Commands\PushSend;

use App\Models\Advert;
use App\Notifications\NewAdvert;
use App\Notifications\NewAdvertDefault;
use Carbon\Carbon;

class NewAdvertPushSend extends BasePushSend {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'AdvertPush:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sending push notifications for new advert';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
        $adverts = Advert::with('destinations')
            ->where('push_sent', 0)
            ->whereHas('destinations')
            ->whereDate('actual_from_date', '<=', Carbon::now())
            ->get();

        foreach ($adverts as $advert) {

            $notification_default = (new NewAdvertDefault())->setTheme($advert->theme);
            $notification = (new NewAdvert())->setTheme($advert->theme);

            $this->sendToMany($advert, $notification, $notification_default);
        }
    }
}
