<?php


namespace App\Console\Commands\PushSend;


use App\Models\Apartment;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;

class BasePushSend extends Command {

    protected $signature = 'BasePush:send';

    /**
     * @param \Illuminate\Database\Eloquent\Model $model
     * @param Notification $notification
     * @param Notification $notification_default
     */
    protected function sendToMany($model, $notification, $notification_default) {
        $destinationsArray = $model->destinations->toArray();
        $apartmentsNumbers = array_filter(array_column($destinationsArray, 'apartment'));

        $apartments = (new Apartment())->whereRaw(0);
        if (!empty($apartmentsNumbers)) {
            $apartments->orWhere(function ($query) use ($model, $apartmentsNumbers) {
                $query
                    ->where('object_id', $model->object_id)
                    ->whereIn('number', array_values($apartmentsNumbers));
            });
        }

        foreach ($model->destinations as $destination) {
            if ($destination->is_all_house) {
                $apartments = Apartment::
                    where('object_id', $model->object_id)
                    ->whereRaw('1');
                break;
            }

            if (!empty($destination->apartment)) {
                continue;
            }

            $apartments->orWhere(function ($query) use ($model, $destination) {
                $query->where('object_id', $model->object_id);

                if (!empty($destination->floor)) {
                    $query->where('floor', '=', $destination->floor);
                }
                if (!empty($destination->entrance)) {
                    $query->where('entrance', '=', $destination->entrance);
                }
            });
        }

        $apartments = $apartments->get()->pluck('id')->toArray();

        if ($apartments) {
            $objectId = $model->object_id;

            $users = User::whereHas('apartments', function ($query) use ($objectId, $apartments) {
                $query
                    ->where('object_id', $objectId)
                    ->whereIn('id', $apartments);
            })->get()->pluck('id')->toArray();

            if(!empty($notification_default)) {
                $push_tokens = (new User)->getPushTokens($users, true);

                foreach ($push_tokens as $os_id => $os_tokens) {
                    if($os_id) {
                        // is iOS
                        Notification::send($os_tokens, $notification_default);
                    } else {
                        // is Android
                        Notification::send($os_tokens, $notification);
                    }
                }

            } else {
                Notification::send((new User)->getPushTokens($users), $notification);
            }

            $model->push_sent = 1;
            $model->save();
        }
    }

    /**
     * @param \Illuminate\Database\Eloquent\Model $model
     * @param Notification $notification
     * @param Notification $notification_default
     */
    protected function sendToOne($model, $notification, $notification_default) {
        $objectId = $model->object_id;
        $apartment = $model->apartment;

        $users = User::whereHas('apartments', function ($query) use ($objectId, $apartment) {
            $query
                ->where('object_id', $objectId)
                ->where('number', $apartment);
        })->get()->pluck('id')->toArray();

        if(!empty($notification_default)) {
            $push_tokens = (new User)->getPushTokens($users, true);

            foreach ($push_tokens as $os_id => $os_tokens) {
                if($os_id) {
                    // is iOS
                    Notification::send($os_tokens, $notification_default);
                } else {
                    // is Android
                    Notification::send($os_tokens, $notification);
                }
            }

        } else {
            Notification::send((new User)->getPushTokens($users), $notification);
        }

        $model->push_sent = 1;
        $model->save();
    }
}