<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class PassportApi extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'passport:api {--force : Overwrite keys they already exist}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run the commands necessary to prepare Passport for use with project API';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->call('passport:keys', ['--force' => $this->option('force')]);

        $this->call('passport:client', ['--personal' => true, '--name' => config('auth.oauth_client_name')]);
    }
}
