<?php

namespace App\Console\Commands;

use App\Models\QuizResult;
use Illuminate\Console\Command;
use App\Models\Apartment;
use App\Models\Quiz;
use App\Models\User;
use Carbon\Carbon;

class CheckQuizFilled extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'CheckQuizFilled';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verifies that all recipients have responded to the survey';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $quizzes = Quiz::with('destinations')
            ->whereHas('destinations')
            ->whereDate('start_at', '<=', Carbon::now())
            ->where('is_filled', '=', 0)
            ->get();

        foreach ($quizzes as $quiz) {
            $destinationsArray = $quiz->destinations->toArray();
            $apartmentsNumbers = array_filter(array_column($destinationsArray, 'apartment'));

            $apartments = (new Apartment())->whereRaw(0);
            if (!empty($apartmentsNumbers)) {
                $apartments->orWhereIn('number', array_values($apartmentsNumbers));
            }

            foreach ($quiz->destinations as $destination) {
                if ($destination->is_all_house) {
                    $apartments = Apartment::whereRaw('1');
                    break;
                }

                if (!empty($destination->apartment)) {
                    continue;
                }
                $apartments->orWhere(function ($query) use ($destination) {
                    if (!empty($destination->floor)) {
                        $query->where('floor', '=', $destination->floor);
                    }
                    if (!empty($destination->entrance)) {
                        $query->where('entrance', '=', $destination->entrance);
                    }
                });
            }

            $apartments = $apartments->get()->pluck('id')->toArray();

            if ($apartments) {
                $userDestination = User::whereHas('apartments', function ($query) use ($apartments) {
                    $query->whereIn('id', $apartments);
                })->get()->pluck('id')->toArray();

                $userResults = QuizResult::where('quiz_id', $quiz->id)
                    ->groupBy('user_id')
                    ->get()
                    ->pluck('user_id')
                    ->toArray();

                if($userDestination == $userResults){
                    $quiz->is_filled = 1;
                    $quiz->save();
                }
            }

        }
    }
}
