@extends('installer::layout', [
    'title' => __('installer::requirements.step_title'),
    'showNextStepButton' => $requirements['checking_result'],
    'showPreviousStepButton' => false,
])

@section('content')
    <table class="table">
        <tbody>
        @foreach ($requirements['requirements'] as $requirement => $result)
            <tr>
                <td>@lang('installer::requirements.' . $requirement)</td>
                <td>
                    @if ($requirement === 'php_version')
                        @if ($result)
                            <span class="badge badge-success">{{ PHP_VERSION }}</span>
                        @else
                            <span class="badge badge-danger">{{ PHP_VERSION }}</span>
                        @endif
                    @elseif ($requirement === 'min_upload_file_size')
                        @if ($result)
                            <span class="badge badge-success">{{ \App\Helpers\PHPini::human_filesize() }}</span>
                        @else
                            <span class="badge badge-danger">{{ \App\Helpers\PHPini::human_filesize() }}</span>
                        @endif
                    @elseif ($requirement === 'min_post_max_size')
                        @if ($result)
                            <span class="badge badge-success">{{ \App\Helpers\PHPini::human_filesize(
                                \evApps\Installer\app\Http\Utilities\ServerRequirementChecker::MIN_POST_MAX_SIZE
                            ) }}</span>
                        @else
                            <span class="badge badge-danger">{{ \App\Helpers\PHPini::human_filesize(
                                \evApps\Installer\app\Http\Utilities\ServerRequirementChecker::MIN_POST_MAX_SIZE
                            ) }}</span>
                        @endif
                    @elseif ($requirement === 'max_execution_time')
                        @if ($result)
                            <span class="badge badge-success">{{ ini_get('max_execution_time') }} @lang('installer::requirements.seconds')</span>
                        @else
                            <span class="badge badge-danger">
                              {{ ini_get('max_execution_time') }} @lang('installer::requirements.seconds')
                              <
                              {{ \evApps\Installer\app\Http\Utilities\ServerRequirementChecker::MAX_EXECUTION_TIME }} @lang('installer::requirements.seconds')
                            </span>
                        @endif
                    @elseif (strpos($requirement, 'php_extension_') === 0)
                        @if ($result)
                            <span class="badge badge-success">@lang('installer::requirements.installed')</span>
                        @else
                            <span class="badge badge-danger">@lang('installer::requirements.not_installed')</span>
                        @endif
                    @elseif (strpos($requirement, 'writable_') === 0)
                        @if ($result)
                            <span class="badge badge-success">@lang('installer::requirements.writable')</span>
                        @else
                            <span class="badge badge-danger">@lang('installer::requirements.not_writable')</span>
                        @endif
                    @endif
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

    @if ($requirements['checking_result'])
        <div class="alert alert-success mb-0" role="alert">
            @lang('installer::requirements.requirements_ok')
        </div>
    @else
        <div class="alert alert-danger mb-0" role="alert">
            @lang('installer::requirements.requirements_error')
        </div>
    @endif
@endsection
