<!doctype html>
<html lang="{{ App::getLocale() }}">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="Cache-Control" content="no-cache">

    {{-- Encrypted CSRF token for Laravel, in order for Ajax requests to work --}}
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@lang('installer::layout.title')</title>

    @yield('before_styles')

    <!-- Bootstrap CSS -->
    <link rel="stylesheet"
          href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.2/css/bootstrap.min.css"
          integrity="sha384-Smlep5jCw/wG7hdkwQ/Z5nLIefveQRIY9nfy6xoR1uRYBtpZgI6339F5dgvm/e9B"
          crossorigin="anonymous">

    <!-- Package styles -->
    <link rel="stylesheet" href="{{ asset('vendor/evapps/installer') }}/css/styles.css?v=18.07.2018">

    @yield('after_styles')
</head>
<body>

<div class="container">
    <div class="card">
        <div class="card-header p-0">
            <nav class="navbar navbar-expand-md navbar-light bg-light">
                <a class="navbar-brand"
                   href="{{ config('evapps.installer.trueip_site.link') }}"
                   target="_blank">
                    <img src="{{ asset('vendor/evapps/installer') }}/images/t-nect-logo.png"
                         class="d-inline-block align-top"
                         alt="{{ __('installer::layout.trueip_site.name') }}"
                         title="{{ __('installer::layout.trueip_site.name') }}">
                </a>

                <button class="navbar-toggler"
                        type="button"
                        data-toggle="collapse"
                        data-target="#navbarNavDropdown"
                        aria-controls="navbarNavDropdown"
                        aria-expanded="false"
                        aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarNavDropdown">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle"
                               href="#"
                               id="navbarDropdownLanguageMenuLink"
                               role="button"
                               data-toggle="dropdown"
                               aria-haspopup="true"
                               aria-expanded="false">
                                @lang('installer::installer.locales.' . App::getLocale())
                            </a>

                            <div class="dropdown-menu" aria-labelledby="navbarDropdownLanguageMenuLink">
                                @foreach(config('evapps.installer.locales') as $locale)
                                    <a class="dropdown-item" href="{{ route('evapps.installer.setLocale', ['locale' => $locale]) }}">
                                        @lang('installer::installer.locales.' . $locale)
                                    </a>
                                @endforeach
                            </div>
                        </li>
                    </ul>
                </div>
            </nav>
        </div>

        <form method="post"
              action="{{ url()->current() }}"
        >
            @csrf
        <div class="card-body">
            <h5 class="card-title">{{ $title }}</h5>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @yield('content')
        </div>

        @php
            $showPreviousStepButton = !isset($showPreviousStepButton) || $showPreviousStepButton;
            $showNextStepButton = !isset($showNextStepButton) || $showNextStepButton;

            if ($showPreviousStepButton && $showNextStepButton) {
                $flexClass = 'justify-content-between';
            } else {
                $flexClass = 'justify-content-end';
            }
        @endphp

        @if ($showNextStepButton || $showPreviousStepButton)
            <div class="card-footer d-flex {{ $flexClass }}">
                @if ($showPreviousStepButton)
                    <a href="{{ route('evapps.installer.' . $previousStepName . '-show-step-form') }}" class="btn btn-primary">
                        @lang('installer::layout.prev_button')
                    </a>
                @endif

                @if ($showNextStepButton)
                    <button type="submit" class="btn btn-primary">@lang('installer::layout.next_button')</button>
                @endif
            </div>
        @endif
        </form>
    </div>
</div>

@yield('before_scripts')

<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"
        integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo"
        crossorigin="anonymous">
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"
        integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49"
        crossorigin="anonymous">
</script>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.2/js/bootstrap.min.js"
        integrity="sha384-o+RDsa0aLu++PJvFqy8fFScvbHFLtbvScb8AjopnFD+iEQ7wo/CG0xlczd+2O/em"
        crossorigin="anonymous">
</script>

@include('backpack::inc.alerts')

@yield('after_scripts')

</body>
</html>
