<?php

namespace evApps\Installer\app\Http\Middleware;

use Closure;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

/**
 * Class IsAlreadyInstalled
 *
 * @package evApps\Installer\app\Http\Middleware
 */
class IsAlreadyInstalled
{


    /**
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     *
     * @return \Illuminate\Http\RedirectResponse|mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Installer::isAlreadyInstalled()) {
            // Redirect to first installation step
            return Redirect::route(
                'evapps.installer.' . Installer::REQUIREMENTS_STEP . '-show-step-form'
            );
        }

        return $next($request);
    }
}
