<?php

namespace evApps\Installer\app\Http\Controllers;

use evApps\Installer\app\Http\Requests\FirstObjectRequest;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Redirect;

/**
 * Class FirstObjectController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class FirstObjectController extends Controller
{

    /**
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View|mixed
     */
    public function showStepForm()
    {
        return view('installer::steps.first_object');
    }

    /**
     * @param \evApps\Installer\app\Http\Requests\FirstObjectRequest $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function saveStepData(FirstObjectRequest $request)
    {
        if (Installer::createFirstObject(
            $request->input('name'),
            $request->input('address'),
            $request->input('sip_server_address'),
            $request->input('sip_server_port'),
            $request->input('concierge_sip_number')
        )) {
            Installer::saveStepData(Installer::FIRST_OBJECT_STEP, [
                'name' => $request->input('name'),
                'address' => $request->input('address'),
                'sip_server_address' => $request->input('sip_server_address'),
                'sip_server_port' => $request->input('sip_server_port'),
                'concierge_sip_number' => $request->input('concierge_sip_number'),
            ]);

            Installer::completeStep(Installer::FIRST_OBJECT_STEP);

            return Redirect::route('evapps.installer.' . Installer::ADMIN_STEP . '-show-step-form');
        } else {
            return Redirect::back()
                ->withErrors(__('installer::first_object.not_created'))
                ->withInput();
        }
    }
}
