<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/*
|--------------------------------------------------------------------------
| Protecting Routes Via Middleware
|--------------------------------------------------------------------------
|
| Check For All Scopes
| ->middleware('scopes:check-status,place-orders');
|
| Check For Any Scopes
| ->middleware('scope:check-status,place-orders');
|
| Attention!
| Your scopes should be urlencoded. For example:
| ->middleware('scope:' . urlencode('full access'));
| or
| ->middleware('scope:' . urlencode('полный доступ'));
|
*/
Route::group(['middleware' => 'localisation'], function () {

    Route::group(['middleware' => 'auth:api'], function () {

        Route::post('/pushtoken', 'DeviceController@pushtoken');
        Route::match(['get', 'put'], '/locale', 'DeviceController@locale');

        Route::get('/device/sipnumber', 'DeviceController@getSipNumber');

        Route::get('/cameras', 'CameraController@index')->middleware('object.api');

        Route::get('/callingpanels', 'CallingPanelController@index')->middleware('object.api');

        // return activations data
        Route::get('/apartment/activations', 'ApartmentController@getActivationsData');

        // Возвращает модель объекта пользователю, выполнившему активацию квартиры
        Route::get('/getobject', 'BuildingController@model');

        Route::group(['middleware' => ['isFullLicenseApi', 'logActivity']], function () {
            Route::get('/adverts', 'AdvertController@index');
            Route::get('/advertsboard', 'AdvertController@index');
            Route::put('/adverts/{advert}', 'AdvertController@markAsRead');

            Route::get('/notifications', 'NoticeController@index');
            Route::put('/notifications/{notice}', 'NoticeController@markAsRead');

            Route::get('/claimtypes', 'ClaimController@types');
            Route::post('/claims', 'ClaimController@createClaim');
            Route::put('/claims/{id}', 'ClaimController@updateClaim');
            Route::get('/claims/{claim}', 'ClaimController@getClaim');
            Route::get('/claims', 'ClaimController@getClaims');

            // claims media
            Route::get('/claims/{id}/images', 'ClaimController@images');
            Route::post('/claims/{id}/images', 'ClaimController@images');

            Route::get('/messages/count', 'MessageController@count');

            Route::post('/recall', 'ReviewController@store');
            Route::get('/recall', 'ReviewController@getRecall');

            Route::post('/recall/answer', 'ReviewController@storeRecallAnswer');
            Route::get('/recall/{id}', 'ReviewController@getRecallAnswers');

            // quiz routes
            Route::post('/quizzes/{quiz}/answers', 'QuizController@setQuizAnswers');
            Route::get('/quizzes/{id}', 'QuizController@getQuizResults');
            Route::put('/quizzes/{quiz}', 'QuizController@markQuizAsRead');
            Route::get('/quizzes', 'QuizController@getUserQuizzes');
        });
    });

    Route::group(['middleware' => 'api-acs'], function(){
      Route::post('/token', 'Auth\\ActivationController@activation')->middleware('localisation');
      Route::delete('/token', 'Auth\\ActivationController@deleteToken')->middleware('auth:api');
      Route::put('/apartment/{id}/activation-code', 'ApartmentController@saveActivationCode');
      Route::put('/apartment/save-activation-codes', 'ApartmentController@saveActivationCodes');
      Route::post('/acs/authorization', 'Auth\\LoginController@acsAuthorization');
      Route::post('/acs/licenseUpdate', 'LicenseController@updateLicense');
    });
});

Route::get('media/images/{image_name}', 'MediaController@getImage');
