<?php

/*
|--------------------------------------------------------------------------
| admin / CRUD Routes
|--------------------------------------------------------------------------
|
| "admin / CRUD" routes for the application.
|
*/

Route::group(['middleware' => 'isNotEmptyObject'], function () {
    Route::get(
        'apartment-generation',
        'ApartmentGenerationController@index'
    );

});

Route::post('camera/add-flats', 'CameraSaveAjaxController@updateCameraToFlats');

Route::post(
    'apartment-generation',
    'ApartmentGenerationController@create'
);

Route::get(
    'apartment-generation-finish',
    'ApartmentGenerationController@finish'
);

Route::post(
    'apartment-generation-save',
    'ApartmentGenerationController@save'
);

Route::get(
    'apartment-generation-remove',
    'ApartmentGenerationController@remove'
);

CRUD::resource('objects', 'BuildingCrudController');

CRUD::resource('devteam', 'DevTeamController')->with(function () {
    Route::get('devteam/feedback', 'DevTeamController@index');
    Route::post('devteam/feedback', ['as'=>'devteam.feedback', 'uses'=>'DevTeamController@feedback']);
});

Route::group(['middleware' => 'isEmptyObject'], function () {
    /**
     * Checking permissions to accessing users to actions and routes was moved into controllers constructors.
     */
    CRUD::resource('apartment', 'ApartmentCrudController')->with(function() {
        Route::get(
            'apartment/{apartment}/reset-activations',
            'ApartmentCrudController@resetActivations'
        );

        Route::get(
          'apartment/{apartment}/reset-code',
          'ApartmentCrudController@resetActivationCode'
        );
    });

    CRUD::resource('camera', 'CameraCrudController');

    CRUD::resource('calling_panel', 'CallingPanelCrudController');

    CRUD::resource('active-users', 'ActiveUsersController');

    Route::group(['middleware' => 'isFullLicense'], function () {
        CRUD::resource('user-activity', 'UserActivityController');
        CRUD::resource('announcement', 'AdvertCrudController')->with(function () {
            Route::get('announcement/{advert}/print', 'AdvertCrudController@printAdvert');
            Route::put('announcement/{advert}/hide', 'AdvertCrudController@hideAdvert');
            Route::get('announcement/{advert}/results', 'AdvertCrudController@results');
        });

        CRUD::resource('notice', 'NoticeCrudController');

        CRUD::resource('claims/types', 'ClaimTypeCrudController');
        CRUD::resource('claims', 'ClaimCrudController')->with(function (){
            Route::get('claims/group', 'ClaimCrudController@groupView');
            Route::put('claims/{id}/claim-accept', 'ClaimCrudController@acceptClaim');
            Route::put('claims/{id}/claim-reject', 'ClaimCrudController@rejectClaim');
            Route::put('claims/{id}/claim-close', 'ClaimCrudController@closeClaim');
        });

        CRUD::resource('review', 'ReviewCrudController')->with(function () {
            Route::get('review/group', 'ReviewCrudController@groupView');
            Route::get('review/{id}/notviewed', 'ReviewCrudController@notViewed');
            Route::get('review/{id}/chat', 'ReviewCrudController@chat');
        });

        CRUD::resource('quizzes', 'QuizCrudController')->with(function () {
            Route::get('quizzes/{id}/results', 'QuizCrudController@results');
            Route::get('quizzes/{id}/results/print', 'QuizCrudController@printResults');
        });

        CRUD::resource('templates/quizzes', 'QuizTemplateCrudController');
        CRUD::resource('templates/categories', 'CategoryCrudController');
        CRUD::resource('templates/messages', 'MessageTemplateCrudController');

        Route::get('templates/styles', 'UserStyleCrudController@index');
        Route::post('templates/styles', 'UserStyleCrudController@store');
        Route::put('templates/styles', 'UserStyleCrudController@update');
    });
});