@extends('backpack::layout')

@section('header')
    <section class="content-header">
        <h1>
            {{ $title }}
        </h1>
        <ol class="breadcrumb">
            <li>
                <a href="{{ url(config('backpack.base.route_prefix'), 'dashboard') }}">{{ trans('backpack::crud.admin') }}</a>
            </li>
            <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
            <li class="active">{{ trans('quizzes.results') }}</li>
        </ol>

    </section>
@endsection

@section('content')
    <!-- Default box -->
    <div class="row">
        @if ($empty)
            <div class="col-sm-12">
                <div><p class="empty bg-danger">{{ trans('quizzes.empty') }}</p></div>
            </div>
        @endif
        <!-- THE ACTUAL CONTENT -->
        <div class="col-sm-12 col-md-2">
            <p>{{ trans('quizzes.crud_fields.status') }}:</p>

        </div>
        <div class="col-sm-12 col-md-10">
            <p>{{ $entry->status }}</p>
        </div>

        <div class="col-sm-12 col-md-2">
            <p>{{ trans('quizzes.crud_fields.question') }}:</p>

        </div>
        <div class="col-sm-12 col-md-10">
            <p>{{ $entry->question }}</p>
        </div>
        <div class="col-xs-12">
            <h4>{{ trans('quizzes.crud_fields.variants') }}:</h4>
        </div>
        @foreach ($entry->answers as $k => $answer)
            <div class="col-sm-12">
                <p class="answer-text">
                    {{ $answer->text }}
                    @if(!$empty)
                        ({{ $answer->percent }}%)
                    @endif
                </p>
            </div>
            @if(!$empty)
                <div class="col-sm-12">
                    <div class="quiz-progress-wrapper">
                        <div  class="bg-info quiz-progress" style="width:{{ $answer->percent }}%"></div>
                    </div>
                </div>
            @endif
        @endforeach

        @if (!$empty && $free_answers_percent)
            <div class="col-sm-12">
                <p class="answer-text">{{ trans('quizzes.another') }} ({{ $free_answers_percent }}%)</p>
            </div>
            <div class="col-sm-12">
                <div class="quiz-progress-wrapper">
                    <div class="bg-info quiz-progress" style="width:{{ $free_answers_percent }}%"></div>
                </div>
            </div>
            <div class="col-sm-12 free-answer-items-holder">
                @foreach ($free_answers as $answer => $apartments)
                    <span data-toggle="tooltip" data-placement="top" title="{{ $apartments }}">

                            {{ $answer }}

                    </span>
                @endforeach
            </div>
        @endif
        <div class="col-xs-12">
            <a href="{{ $printUrl }}" class="btn btn-success">
                <span class="fa fa-print" role="presentation" aria-hidden="true"></span> &nbsp;
                <span>{{ trans('quizzes.buttons.print') }}</span>
            </a>
            <a href="/admin/quizzes/" class="btn btn-default">
                <span class="fa fa-angle-left" role="presentation" aria-hidden="true"></span> &nbsp;
                <span>{{ trans('quizzes.buttons.back') }}</span>
            </a>
        </div>
</div>

@endsection

@section('after_styles')
    <link rel="stylesheet" href="{{ asset('vendor/backpack/quiz/result.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/styles/create.css') }}">

    <!-- CRUD FORM CONTENT - crud_fields_styles stack -->
    @stack('crud_fields_styles')
@endsection




