<!-- dependencyJson -->
<div class="form-group col-md-12 checklist_dependency"  data-entity ="{{ $field['field_unique_name'] }}" @include('crud::inc.field_wrapper_attributes')>
    <label>{!! $field['label'] !!}</label>
    @include('crud::inc.field_translatable_icon')
    <?php
    $entity_model = $crud->getModel();

    //short name for dependency fields
    $primary_dependency = $field['subfields']['primary'];
    $secondary_dependency = $field['subfields']['secondary'];


    //all items with relation
    $dependencies = $primary_dependency['model']::with($primary_dependency['entity_secondary'])->get();

    $dependencyArray = [];

    //convert dependency array to simple matrix ( prymary id as key and array with secondaries id )
    foreach ($dependencies as $primary) {
        $dependencyArray[$primary->id] = [];
        foreach ($primary->{$primary_dependency['entity_secondary']} as $secondary) {
            $dependencyArray[$primary->id][] = $secondary->id;
        }
    }

    //for update form, get initial state of the entity
    if( isset($id) && $id ){

        //get entity with relations for primary dependency
        $entity_dependencies = $entity_model->with($primary_dependency['entity'])
            ->with($primary_dependency['entity'].'.'.$primary_dependency['entity_secondary'])
            ->find($id);

        $secondaries_from_primary = [];

        //convert relation in array
        $primary_array = $entity_dependencies->{$primary_dependency['entity']}->toArray();

        $secondary_ids = [];

        //create secondary dependency from primary relation, used to check what chekbox must be check from second checklist
        if (old($primary_dependency['name'])) {
            foreach (old($primary_dependency['name']) as $primary_item) {
                foreach ($dependencyArray[$primary_item] as $second_item) {
                    $secondary_ids[$second_item] = $second_item;
                }
            }
        } else { //create dependecies from relation if not from validate error
            foreach ($primary_array as $primary_item) {
                foreach ($primary_item[$secondary_dependency['entity']] as $second_item) {
                    $secondary_ids[$second_item['id']] = $second_item['id'];
                }
            }
        }
    }

    //json encode of dependency matrix
    $dependencyJson = json_encode($dependencyArray);
    ?>
    <script>
        var  {{ $field['field_unique_name'] }} = {!! $dependencyJson !!};
    </script>

    <div class="row" >

        @if($primary_dependency['model']::someoneRoleAccess())
        <div class="col-xs-12">
            <label>{!! $primary_dependency['label'] !!}</label>
        </div>
        @endif

        @foreach ($primary_dependency['model']::all() as $connected_entity_entry)
            @php
                if (
                    !\Illuminate\Support\Facades\Auth::user()->hasPermissionTo(\App\Models\PermissionManager\Permission::FULL_ACCESS)
                    &&
                    !\Illuminate\Support\Facades\Auth::user()->hasRole($connected_entity_entry)
                ) {
                   continue;
                }
            @endphp

            <div class="col-sm-{{ isset($primary_dependency['number_columns']) ? intval(12/$primary_dependency['number_columns']) : '4'}}">
                <div class="checkbox" data-name="permissions">
                    <label>
                        <input type="checkbox"
                               data-id = "{{ $connected_entity_entry->id }}"
                               data-permission = "{{ $connected_entity_entry->{$primary_dependency['attribute']} }}"
                               class = 'primary_list'
                        @foreach ($primary_dependency as $attribute => $value)
                            @if (is_string($attribute) && $attribute != 'value')
                                @if ($attribute=='name')
                                    {{ $attribute }}="{{ $value }}[]"
                                @else
                                    {{ $attribute }}="{{ $value }}"
                                @endif
                            @endif
                        @endforeach
                        value="{{ $connected_entity_entry->id }}"

                        @if( ( isset($field['value']) && is_array($field['value']) && in_array($connected_entity_entry->id, $field['value'][0]->pluck('id', 'id')->toArray())) || ( old($primary_dependency["name"]) && in_array($connected_entity_entry->id, old( $primary_dependency["name"])->toArray()) ) )
                            checked = "checked"
                        @endif >
                        {{ $connected_entity_entry->{$primary_dependency['attribute']} }}
                    </label>
                </div>
            </div>
        @endforeach
    </div>

    <div class="row">
        <div class="col-xs-12">
            <label>{!! $secondary_dependency['label'] !!}</label>
        </div>

        @foreach ($secondary_dependency['model']::all() as $connected_entity_entry)
            @php
                if (!\Illuminate\Support\Facades\Auth::user()->hasPermissionTo($connected_entity_entry)) {
                   continue;
                }
            @endphp

            <div class="col-sm-{{ isset($secondary_dependency['number_columns']) ? intval(12/$secondary_dependency['number_columns']) : '4'}}">
                <div class="checkbox" data-name="permissions">
                    <label>
                        <input type="checkbox"
                               class = 'secondary_list'
                               data-id = "{{ $connected_entity_entry->id }}"
                               data-permission = "{{ $connected_entity_entry->{$primary_dependency['attribute']} }}"
                        @foreach ($secondary_dependency as $attribute => $value)
                            @if (is_string($attribute) && $attribute != 'value')
                                @if ($attribute=='name')
                                    {{ $attribute }}="{{ $value }}[]"
                                @else
                                    {{ $attribute }}="{{ $value }}"
                                @endif
                            @endif
                        @endforeach
                        value="{{ $connected_entity_entry->id }}"

                        @if( ( isset($field['value']) && is_array($field['value']) && (  in_array($connected_entity_entry->id, $field['value'][1]->pluck('id', 'id')->toArray()) || isset( $secondary_ids[$connected_entity_entry->id])) || ( old($secondary_dependency['name']) &&   in_array($connected_entity_entry->id, old($secondary_dependency['name'])->toArray()) )))
                            checked = "checked"
                        @endif > {{ $connected_entity_entry->{$secondary_dependency['attribute']} }}
                    </label>
                </div>
            </div>
        @endforeach
    </div>

    {{-- HINT --}}
    @if (isset($field['hint']))
        <p class="help-block">{!! $field['hint'] !!}</p>
    @endif

</div>

{{-- ########################################## --}}
{{-- Extra CSS and JS for this particular field --}}
{{-- If a field type is shown multiple times on a form, the CSS and JS will only be loaded once --}}
@if ($crud->checkIfFieldIsFirstOfItsType($field, $fields))

    {{-- FIELD CSS - will be loaded in the after_styles section --}}
    @push('crud_fields_styles')
    @endpush

    {{-- FIELD JS - will be loaded in the after_scripts section --}}
    @push('crud_fields_scripts')
        <script>
            jQuery('document').ready(function() {
                var owner = {!!$owner!!};

                if (owner) {
                    $('[data-name="permissions"] input[type="checkbox"]').prop('disabled', true);
                } else {
                    var raw_roles = JSON.parse('{!!$roles!!}');
                    var permissions = JSON.parse('{!!$permissions!!}');
                    var full_access = JSON.parse('{!!$full_access!!}');

                    var input_roles = $('label input[name="roles[]"]');
                    var input_permissions = $('label input[name="permissions[]"]');

                    var roles = addMissingPermissionsToRoles(raw_roles, permissions);

                    // Получить идентификатор полного доступа
                    var full_access_id = getFullAccess();
                    var full_access_object = $('label input[name="permissions[]"][data-id="' + full_access_id + '"]');

                    // Заблокировать чекбоксы всех выбранных ролей
                    correctRoles(input_roles, roles);

                    // Заблокировать все права при загрузке, если выбран "полный доступ"
                    if (full_access_object.prop('checked') === true || full_access) {
                        bootBlockAll(input_permissions, full_access_id);
                    }

                    // Обработка клика по определенной роли
                    input_roles.click(function () {
                        var role_full_access = roleFullAccessCheck($(this), roles, full_access_id);

                        if (!fullAccessChecked(input_permissions, full_access_id) || role_full_access) {
                            // Идентификатор текущей роли
                            var role_id = $(this).attr('data-id');

                            //console.log(input_permissions.find('input[data-id="'+full_access_id+'"]'));

                            // Проверка на активность или неактивность чекбокса
                            if ($(this).prop('checked') === true) {
                                // Если чекбокс активен

                                if (role_full_access) {
                                    blockAll(input_permissions, full_access_id, true);
                                    full_access_object.prop('checked', true).prop('disabled', true);
                                    return true;
                                }

                                // Пройти по массиву прав, сделав все соответствующие чекбоксы активными
                                checkRoles(input_permissions, roles, role_id, true, true);
                            } else {
                                // Если чекбокс неактивен

                                // Проверка на возможность снятия блокировки (если у других ролей тоже есть полный доступ)
                                if (!checkActiveFullAccessRoles(input_roles, roles, full_access_id)) {
                                    if (role_full_access) {
                                        full_access_object.prop('checked', false).prop('disabled', false);
                                        blockAll(input_permissions, full_access_id, false);
                                    }

                                    // Пройти по массиву прав, сделав все соответствующие чекбоксы неактивными
                                    checkRoles(input_permissions, roles, role_id, false, false);

                                    // Пройтись по всем активным ролям, устранив конфликт
                                    correctRoles(input_roles, roles);
                                }
                            }
                        }
                    });

                    // Обработка клика по определенному праву
                    input_permissions.click(function () {
                        // Идентификатор текущего права
                        var permission_id = $(this).attr('data-id');

                        if ($(this).prop('checked') === true) {

                            if (permissions[permission_id].hasOwnProperty('full_access') && permissions[permission_id].full_access === true) {
                                // Если выбрано правило "полный доступ", то блокируем все остальные правила
                                blockAll(input_permissions, permission_id, true);
                                return true;
                            }

                            var need_to_check = getPermissionsByWeight(permissions, permission_id, false);
                            checkPermissions(input_permissions, need_to_check, true);
                            correctRoles(input_roles, roles);
                        } else {

                            if (permissions[permission_id].hasOwnProperty('full_access') && permissions[permission_id].full_access === true) {
                                // Если выбрано правило "полный доступ", то разброкируем другие правила
                                blockAll(input_permissions, permission_id, false);
                            }

                            var need_to_check = getPermissionsByWeight(permissions, permission_id, false, false);
                            checkPermissions(input_permissions, need_to_check, false);
                            correctRoles(input_roles, roles);
                        }
                    });

                    // Блокировка или снятие блокировки с остальных галочек
                    function blockAll(input_permissions, full_access_id, block = true, full_access_check = false) {
                        input_permissions.each(function () {
                            if ($(this).attr('data-id') !== full_access_id) {
                                $(this).prop('checked', false).prop('disabled', block);

                                if (full_access_check) {
                                    $(this).prop('checked', true).prop('disabled', block);
                                }
                            }
                        });
                    }

                    // Заблокировать все права при загрузке, если выбран полный доступ
                    function bootBlockAll(input_permissions, full_access_id, block = true) {
                        if (full_access_id) {
                            blockAll(input_permissions, full_access_id, block);
                        }
                    }

                    // Проверить активность чекбокса "полный доступ"
                    function fullAccessChecked(input_permission, full_access_id) {
                        checked = false;

                        input_permissions.each(function () {
                            if ($(this).attr('data-id') === full_access_id && $(this).prop('checked') === true) {
                                return checked = true;
                            }
                        });

                        return checked;
                    }

                    // Получить идентификатор полного доступа
                    function getFullAccess() {
                        var permissions_keys = Object.keys(permissions);
                        var full_access_id = null;

                        // Найти идентификатор полного доступа
                        permissions_keys.forEach(function (permission_key) {
                            if (permissions[permission_key].hasOwnProperty('full_access') && permissions[permission_key].full_access === true) {
                                full_access_id = permission_key;
                            }
                        });

                        return full_access_id;
                    }

                    // Проверить наличие у выбранной роли права "полный доступ"
                    function roleFullAccessCheck(role, roles, full_access_id) {
                        role_id = role.attr('data-id');

                        full_access = false;

                        roles[role_id].forEach(function (permission) {
                            if (Number(permission) === Number(full_access_id)) {
                                return full_access = true;
                            }
                        });

                        return full_access;
                    }

                    // Остались ли еще роли с полным доступом?
                    function checkActiveFullAccessRoles(input_roles, roles, full_access_id) {
                        var full_access_role = false;

                        input_roles.each(function () {
                            var role_id = $(this).attr('data-id');

                            // Выбранна ли данная роль?
                            if ($(this).prop('checked') === true) {
                                // Есть ли в данной роли право с полным доступом?
                                var full_access_permission = false;

                                roles[role_id].forEach(function (permission_id) {
                                    if (Number(permission_id) === Number(full_access_id)) {
                                        full_access_permission = true;
                                        return true;
                                    }
                                });

                                if (full_access_permission) {
                                    full_access_role = true;
                                    return true;
                                }
                            }
                        });

                        return full_access_role;
                    }

                    // Установка или снятие галочек для ролей
                    function checkRoles(input_permissions, roles, role_id, checked = true, disabled = true) {
                        input_permissions.each(function () {
                            if (typeof(roles[role_id]) !== "undefined") {
                                // Если data-id соответствует id одного из прав текущей роли, делаем его checked и disable
                                if (roles[role_id].includes(Number($(this).attr('data-id')))) {
                                    $(this).prop('checked', checked).prop('disabled', disabled);
                                }
                            }
                        });
                    }

                    // Установка или снятие галочек для прав
                    function checkPermissions(input_permissions, permissions_keys, checked = true) {
                        input_permissions.each(function () {
                            var id = $(this).attr('data-id');
                            if (permissions_keys.includes(Number(id))) {
                                $(this).prop('checked', checked);
                            }
                        });
                    }


                    // Получить новый массив ролей (добавить недостающие права)
                    function addMissingPermissionsToRoles(raw_roles, permissions) {
                        var roles_keys = Object.keys(raw_roles);
                        var roles = [];

                        roles_keys.forEach(function (key) {
                            var new_permissions = [];
                            // Пройти по циклу ролей и составить новый список ролей
                            raw_roles[key].forEach(function (permission) {
                                new_permissions = new_permissions.concat(getPermissionsByWeight(permissions, permission, true));
                            });

                            roles[key] = new_permissions.filter(function (value, index, self) {
                                return self.indexOf(value) === index;
                            });
                        });

                        return roles;
                    }

                    // Получить список прав по весу меньших, чем текущее
                    function getPermissionsByWeight(permissions, id, current = false, weight = true) {
                        var permissions_keys = Object.keys(permissions);
                        var weightPermissions = [];

                        permissions_keys.forEach(function (key) {
                            if (weight) {
                                if (permissions[key].group === permissions[id].group && permissions[key].weight < permissions[id].weight) {
                                    weightPermissions.push(Number(key));
                                }
                            } else {
                                if (permissions[key].group === permissions[id].group && permissions[key].weight > permissions[id].weight) {
                                    weightPermissions.push(Number(key));
                                }
                            }
                        });

                        // Добавить текущий элемент, если требуется
                        if (current) {
                            weightPermissions.push(id);
                        }

                        // Отсортировать по возрастанию
                        weightPermissions = weightPermissions.sort(function (a, b) {
                            return a - b;
                        });

                        return weightPermissions;
                    }

                    // Пройтись по всем активным ролям и установить галочки для активных
                    function correctRoles(input_roles, roles) {
                        input_roles.each(function () {
                            if ($(this).prop('checked') === true) {
                                checkRoles(input_permissions, roles, $(this).attr('data-id'), true, true)
                            }
                        });
                    }
                }
            });
        </script>
    @endpush

@endif
{{-- End of Extra CSS and JS --}}
{{-- ########################################## --}}
