<!-- select2 -->
<div @include('crud::inc.field_wrapper_attributes') >
    <label>{!! $field['label'] !!}</label>
    <div class="checkbox">
        <label>
            <input type="checkbox" name="check-all" class="js-ac-all" @if($field['check_all']) checked @endif>
            {{ trans('apartments.crud_fields.select_all') }}
        </label>
    </div>
    @include('crud::inc.field_translatable_icon')

    <?php
        $check_list = [];

        if(!empty($field['object_id'])) {
            $connected_entity_entries = $field['model']::where('object_id', $field['object_id'])->get();
        } else {
            $connected_entity_entries = $field['model']::all();
        }


        foreach ($connected_entity_entries as $connected_entity_entry) {
            $label = null;
            $active_numbers = 0;
            $entrance = !empty($connected_entity_entry->entrance) ? $connected_entity_entry->entrance : null;
            $floor = !empty($connected_entity_entry->floor) ? $connected_entity_entry->floor : null;
            $apartment_id = !empty($connected_entity_entry->id) ? $connected_entity_entry->id : null;
            $apartment_number = !empty($connected_entity_entry->number) ? $connected_entity_entry->number : '---';

            if(!empty($field['attributes'])) {
                foreach($field['attributes'] as $attribute_key => $attribute_name) {
                    $label .= $attribute_name . ': ';
                    $label .= '<b>' . $connected_entity_entry->{$attribute_key} . '</b> ';
                }
            }

            if(!empty($entrance) && !empty($floor) && !empty($apartment_number) && !empty($apartment_id)) {
                $apartment_fields = [
                    'id' => $apartment_id,
                    'key' => $connected_entity_entry->getKey(),
                    'name' => $field['name'],
                    'label' => $label

                ];

                if( ( old( $field["name"] ) && in_array($connected_entity_entry->getKey(), old( $field["name"])) ) || (isset($field['value']) && in_array($connected_entity_entry->getKey(), $field['value']->pluck($connected_entity_entry->getKeyName(), $connected_entity_entry->getKeyName())->toArray()))) {
                    $apartment_fields['active'] = true;
                } else {
                    $apartment_fields['active'] = false;
                }

                $check_list[$entrance][$floor][] = $apartment_fields;
            }
        }

        foreach($check_list as $e_key => $e_v) {
            ksort($e_v);
            $check_list[$e_key] = $e_v;
        }
?>

        @foreach ($check_list as $entrance_key => $entrance)
            <div class="panel panel-default aparts-binding">
                <div data-toggle="collapse" data-target="#entrance-{{ $entrance_key }}" aria-expanded="false" aria-controls="collapseExample" class="panel-heading" style="cursor: pointer">
                    <b> {{ trans('apartments.crud_fields.entrance') }} {{ $entrance_key }}</b> <span class="label label-default aparts-binding-group-count">-</span>
                </div>

                <div id="entrance-{{ $entrance_key }}" class="panel-body collapse">
                    @foreach($entrance as $floor_key => $foor)
                        <b>{{ trans('apartments.crud_fields.floor') }} {{ $floor_key }}</b>
                        @foreach($foor as $apartment)
                            <div class="checkbox">
                                <label>
                                    &nbsp;&nbsp;&nbsp;<input type="checkbox" value="{{ $apartment['key'] }}"
                                           name="{{ $apartment['name'] }}[]"
                                            class="aparts-binding-input"
                                    @if($field['check_all'] || $apartment['active']) checked @endif
                                    >
                                    {!! $apartment['label'] !!}
                                </label>
                            </div>
                        @endforeach
                    @endforeach
                </div>
            </div>
        @endforeach


{{-- HINT --}}
@if (isset($field['hint']))
<p class="help-block">{!! $field['hint'] !!}</p>
@endif
</div>
