@push('after_scripts')
    <script type="text/javascript">
        jQuery(document).ready(function ($) {
            @if ($crud->exportButtons())
            // move the datatable buttons in the top-right corner and make them smaller
            table.buttons().each(function (button) {
                if (button.node.className.indexOf('buttons-columnVisibility') == -1) {
                    button.node.className = button.node.className + " btn-sm";
                }
            });
            $(".dt-buttons").appendTo($('#datatable_button_stack'));
            @endif

            $.ajaxPrefilter(function (options, originalOptions, xhr) {
                var token = $('meta[name="csrf_token"]').attr('content');

                if (token) {
                    return xhr.setRequestHeader('X-XSRF-TOKEN', token);
                }
            });

            // make the delete button work in the first result page
            register_delete_button_action();
            bind_claims_actions();
            // make the delete button work on subsequent result pages
            $('#crudTable').on('draw.dt', function () {
                register_delete_button_action();
                $('.claim-actions-buttons button').off('click');
                bind_claims_actions();
                @if ($crud->details_row)
                register_details_row_button_action();
                @endif

                updateClaimButtonsModalView();
            }).dataTable();

            $('body').on( 'click', function () {
                register_delete_button_action();
                $('.claim-actions-buttons button').off('click');
                bind_claims_actions();
                @if ($crud->details_row)
                register_details_row_button_action();
                @endif

                updateClaimButtonsModalView();

                var modal = $('.modal-dialog .status-name-value');
                var m_id = modal.attr('data-id');

                $('.modal-dialog .status-name-value').html($('#crudTable .status-name-value[data-id="'+m_id+'"]').html());
            });

            // Обновить стиль кнопок модального окна
            function updateClaimButtonsModalView()
            {
                $('.modal-dialog .claim-actions-buttons button').each(function () {
                    var $id = $(this).attr('data-id-claim');
                    var $action = $(this).attr('data-action');

                    $disabled = $('#crudTable button[data-id-claim="'+$id+'"][data-action="'+$action+'"]').prop('disabled');

                    $(this).prop('disabled', $disabled);

                    if (typeof $disabled == 'undefined') {
                        $(this).remove();
                    }
                });
            }

            updateClaimButtonsModalView();

            function bind_claims_actions() {
                $('.claim-actions-buttons button').click(function (e) {
                    e.preventDefault();
                    var $btn = $(this);
                    var action = $btn.data('action');
                    var claimId = $btn.data('id-claim');
                    var action_url = $btn.data('href');
                    var $mainButtons = $('button[data-id-claim="'+claimId+'"]').parent('.claim-actions-buttons');
                    var $statusTextContainer = $mainButtons.closest('tr').find('.status-name-value');
                    if (action == 'accept' || confirm("{{ trans('claims.claim_ask_confirm') }}") == true) {
                        $.ajax({
                            url: action_url,
                            type: 'PUT',
                            success: function (result) {
                                new PNotify({
                                    title: "{{ trans('claims.action_successful_result') }}",
                                    text: "{{ trans('claims.claim') }} №" + claimId + " " + result.result,
                                    type: "success"
                                });
                                $statusTextContainer.html(result.result);
                                updateButtonsView($mainButtons, result.statusId);

                                // Hide the modal, if any
                                $('.modal').modal('hide');
                            },
                            error: function (result) {
                                new PNotify({
                                    title: "{{ trans('claims.claims') }}",
                                    text: "{{ trans('claims.server_error') }}",
                                    type: "warning"
                                });
                            }
                        });
                    }
                    else {
                        new PNotify({
                            title: "{{ trans('claims.claims') }}",
                            text: "{{ trans('claims.action_not_executed') }}",
                            type: "info"
                        });
                    }
                });
            }

            function updateButtonsView($buttons, statusId) {
                var entry = 0;
                $buttons.find('button').each(function () {
                    $(this).prop('disabled', 0);
                    entry = $(this).attr('data-id-claim');
                });

                var row = $('tr[data-entry-id="'+entry+'"]');

                switch (statusId) {
                    case 1:
                        $buttons.find('.claim-accept').prop('disabled', 1);
                        row.removeClass('font-weight-900').addClass('font-weight-600');
                        break;
                    case 2:
                        $buttons.find('.claim-accept').prop('disabled', 1);
                        $buttons.find('.claim-reject').prop('disabled', 1);
                        $buttons.remove();
                        row.removeClass('font-weight-900 font-weight-600');
                        break;
                    case 3:
                        $buttons.remove();
                        row.removeClass('font-weight-900 font-weight-600');
                        break;
                    default:
                        break;
                }
            }

            function register_delete_button_action() {
                $("[data-button-type=delete]").unbind('click');
                // CRUD Delete
                // ask for confirmation before deleting an item
                $("[data-button-type=delete]").click(function (e) {
                    e.preventDefault();
                    var delete_button = $(this);
                    var delete_url = $(this).attr('href');

                    if (confirm("{{ trans('backpack::crud.delete_confirm') }}") == true) {
                        $.ajax({
                            url: delete_url,
                            type: 'DELETE',
                            success: function (result) {
                                // Show an alert with the result
                                new PNotify({
                                    title: "{{ trans('backpack::crud.delete_confirmation_title') }}",
                                    text: "{{ trans('backpack::crud.delete_confirmation_message') }}",
                                    type: "success"
                                });
                                // delete the row from the table
                                delete_button.parentsUntil('tr').parent().remove();

                                // Hide the modal, if any
                                $('.modal').modal('hide');
                            },
                            error: function (result) {
                                // Show an alert with the result
                                new PNotify({
                                    title: "{{ trans('backpack::crud.delete_confirmation_not_title') }}",
                                    text: "{{ trans('backpack::crud.delete_confirmation_not_message') }}",
                                    type: "warning"
                                });
                            }
                        });
                    }
                    else {
                        new PNotify({
                            title: "{{ trans('backpack::crud.delete_confirmation_not_deleted_title') }}",
                            text: "{{ trans('backpack::crud.delete_confirmation_not_deleted_message') }}",
                            type: "info"
                        });
                    }
                });
            }


            @if ($crud->details_row)
            function register_details_row_button_action() {
                // var crudTable = $('#crudTable tbody');
                // Remove any previously registered event handlers from draw.dt event callback
                $('#crudTable tbody').off('click', 'td .details-row-button');

                // Make sure the ajaxDatatables rows also have the correct classes
                $('#crudTable tbody td .details-row-button').parent('td')
                    .removeClass('details-control').addClass('details-control')
                    .removeClass('text-center').addClass('text-center')
                    .removeClass('cursor-pointer').addClass('cursor-pointer');

                // Add event listener for opening and closing details
                $('#crudTable tbody td.details-control').on('click', function () {
                    var tr = $(this).closest('tr');
                    var btn = $(this).find('.details-row-button');
                    var row = table.row(tr);

                    if (row.child.isShown()) {
                        // This row is already open - close it
                        btn.removeClass('fa-minus-square-o').addClass('fa-plus-square-o');
                        $('div.table_row_slider', row.child()).slideUp(function () {
                            row.child.hide();
                            tr.removeClass('shown');
                        });
                    }
                    else {
                        // Open this row
                        btn.removeClass('fa-plus-square-o').addClass('fa-minus-square-o');
                        // Get the details with ajax
                        $.ajax({
                            url: '{{ url($crud->route) }}/' + btn.data('entry-id') + '/details',
                            type: 'GET',
                            // dataType: 'default: Intelligent Guess (Other values: xml, json, script, or html)',
                            // data: {param1: 'value1'},
                        })
                            .done(function (data) {
                                // console.log("-- success getting table extra details row with AJAX");
                                row.child("<div class='table_row_slider'>" + data + "</div>", 'no-padding').show();
                                tr.addClass('shown');
                                $('div.table_row_slider', row.child()).slideDown();
                                register_delete_button_action();
                            })
                            .fail(function (data) {
                                // console.log("-- error getting table extra details row with AJAX");
                                row.child("<div class='table_row_slider'>{{ trans('backpack::crud.details_row_loading_error') }}</div>").show();
                                tr.addClass('shown');
                                $('div.table_row_slider', row.child()).slideDown();
                            })
                            .always(function (data) {
                                // console.log("-- complete getting table extra details row with AJAX");
                            });
                    }
                });
            }

            register_details_row_button_action();
            @endif
        });
    </script>

    <script src="{{ asset('vendor/backpack/colorbox/jquery.colorbox-min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('vendor/backpack/colorbox/i18n/jquery.colorbox-ru.js') }}" type="text/javascript"></script>

    <script type="text/javascript">
        jQuery(document).ready(function ($) {
            $('body').on('click', '.js-illustration-group', function () {
                $('.js-illustration-group').colorbox({
                    maxWidth: '85%',
                    maxHeight: '85%',
                    rel: function() {
                        return $(this).data('group');
                    }
                });
                $(this).click();
            });
        });

        $(document).bind('cbox_closed', function(){
            setTimeout(function () {
                $('.js-illustration-group').blur();
            }, 200);
        });
    </script>
@endpush
