@extends('backpack::layout')

@section('header')
	<section class="content-header">
	  <h1>
	    {{ trans('backpack::crud.add') }} <span>{{ $crud->entity_name }}</span>
	  </h1>
	  <ol class="breadcrumb">
	    <li><a href="{{ url(config('backpack.base.route_prefix'), 'dashboard') }}">{{ trans('backpack::crud.admin') }}</a></li>
	    <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
	    <li class="active">{{ trans('backpack::crud.add') }}</li>
	  </ol>
	</section>
@endsection

@section('content')
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<!-- Default box -->
		@if ($crud->hasAccess('list'))
			<a href="{{ url($crud->route) }}"><i class="fa fa-angle-double-left"></i> {{ trans('backpack::crud.back_to_all') }} <span>{{ $crud->entity_name_plural }}</span></a><br><br>
		@endif

		@include('crud::inc.grouped_errors')

		<form method="post"
			  action="{{ url($crud->route) }}"
			  @if ($crud->hasUploadFields('create'))
			  enctype="multipart/form-data"
				@endif
			  class="camera-create-form"
			  data-step="0"
		>
			{!! csrf_field() !!}
		  <div class="box">

		    <div class="box-header with-border">
		      <h3 class="box-title">{{ trans('backpack::crud.add_a_new') }} {{ $crud->entity_name }}</h3>
		    </div>
		    <div class="box-body row">
		      <!-- load the view from the application if it exists, otherwise load the one in the package -->
		      @if(view()->exists('vendor.backpack.crud.form_content'))
		      	@include('vendor.backpack.crud.form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])
		      @else
		      	@include('crud::form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])
		      @endif
		    </div><!-- /.box-body -->
		    <div class="box-footer">

                @include('crud::inc.form_save_buttons_extended')

		    </div><!-- /.box-footer-->

		  </div><!-- /.box -->
		</form>
	</div>
</div>
<div class="preloader">
    <div class="preloader__info">
        <img src="/assets/preloader.gif"  class="preloader__image">
    </div>
</div>
@endsection

@push('after_scripts')
	<script>
        $(document).ready(function($) {
           $('.camera-create-form').submit(function(e) {
               e.preventDefault();
               var $form = $(this);
               var $step = $form.data('step');
               var $group = $form.find('.aparts-binding');

               var $mainFields = $form.find('input:not(.aparts-binding-input)');

               if ($step == 0) {
                   $('.preloader').addClass('preloader_state_open');
                   $.ajax({
                       dataType: 'json',
                       method: 'POST',
                       data: $mainFields.serialize(),
                       url: '/admin/camera',
                       success: function (data) {
                           $form.data('id', data.data.id);
                           setTimeout(function () {
                               addCameraToFlats($step, $group, $mainFields, $form);
			   				}, 1000);
                       },
                       error: function (data) {
                           $('.preloader').removeClass('preloader_state_open');
                           $form.find('.has-error').removeClass('has-error');
                           $form.find('.text-danger').remove();
                           var errors = $.parseJSON(data.responseText);
                           $.each(errors['errors'], function (key, value) {
                               $form.find('input[name="' + key + '"]').parent().addClass('has-error');
                               $form.find('input[name="' + key + '"]').after('<span class="text-danger">' + value + '</span>');
                           });
                       }
                   });
               } else {
                   addCameraToFlats($step, $group, $mainFields, $form);
			   }

		   });
        });

        function addCameraToFlats($step, $group, $mainFields, $form) {
            var $id = $form.data('id');
            if ($id && $group.length > 0) {
                var $fields = $($group[$step]).find('.aparts-binding-input');
                if ($fields.length > 0) {
                    var $fieldsData = $fields.serialize() + '&' + $mainFields.serialize() + '&id=' + $id;
                    $.ajax({
                        dataType: 'json',
                        method: 'POST',
                        data: $fieldsData,
                        url: '/admin/camera/add-flats',
                        success: function (data) {
                            var $newStep = $step + 1;
							if ($newStep + 1 > $group.length) {
							    location.href = data.redirect_url;
							} else {
							    $form.data('step', $newStep);
                                addCameraToFlats($step + 1, $group, $mainFields, $form);
							}
                        },
                        error: function (data) {
                            $('.preloader').removeClass('preloader_state_open');
                        }
                    });
				}
			}
		}

        $(document).on('keyup', '.camera-create-form input[name="name"], .camera-create-form input[name="rtsp_link"]', function(){
            var emptyFields = 'N';
            $('.has-error input').each(function() {
                if ($(this).val() == '') {
                    emptyFields = 'Y';
				}
			});
			if (emptyFields == 'N') {
			    $('.camera-create-form #saveActions button').removeAttr('disabled');
			}
        });

	</script>
@endpush