@extends('crud::list')

@push('activation_info')
    {{ trans('apartments.activated_by_users') }} -
    @if (isset($used_by_users_count))
        &nbsp;{{$used_by_users_count}}
    @else
        &nbsp;0
    @endif
    ,
    {{ trans('apartments.connected_to_apartments') }} -
    @if (isset($used_activations_count))
        &nbsp;{{$used_activations_count}}
    @else
        &nbsp;0
    @endif
    ,
    {{ trans('apartments.total') }} -
    @if (isset($available_activations_count))
        &nbsp;{{$available_activations_count}}
    @else
        &nbsp;0
    @endif
    .
@endpush

@push('information')
    <h3>
    @if (isset($used_activations_count) && isset($available_activations_count) && !is_null($acs_server_answer))
        {{__('apartments.activations.used')}} {{$used_activations_count}} {{__('apartments.activations.activations_from')}} {{$available_activations_count}}
    @else
        @lang('apartments.activations.acs_no_answer')
    @endif
    </h3>
    <br>
@endpush

@push('after_scripts')
    <script type="text/javascript">
        jQuery(document).ready(function ($) {

            // make the delete button work in the first result page
            register_delete_button_action();


            // make the reset-activations button work in the first result page
            register_reset_activations_button_action();

            // make the delete button work on subsequent result pages
            $('#crudTable').on('draw.dt', function () {
                register_delete_button_action();
                register_reset_activations_button_action();

                @if ($crud->details_row)
                register_details_row_button_action();
                @endif
            }).dataTable();

            // make the delete button work on subsequent result pages
            $('body').on('click', function () {
                register_delete_button_action();
                register_reset_activations_button_action();

                @if ($crud->details_row)
                register_details_row_button_action();
                @endif

                var activ_used = $('.modal-dialog .activations-used-value');
                var m_id = activ_used.attr('data-id');
                $parent_used = $('#crudTable a[data-button-type="reset_activation"][data-id="'+m_id+'"]')
                    .parentsUntil('tr')
                    .parent()
                    .find('.activations-used-value');

                activ_used.html($parent_used.html());

                $('.modal-dialog .sip-numbers').html($('#crudTable span.sip-numbers[data-id="'+m_id+'"]').html());
            }).dataTable();


            function register_delete_button_action() {
                $("[data-button-type=delete]").unbind('click');
                // CRUD Delete
                // ask for confirmation before deleting an item
                $("[data-button-type=delete]").click(function (e) {
                    e.preventDefault();
                    var delete_button = $(this);
                    var delete_url = $(this).attr('href');

                    if (confirm("{{ trans('backpack::crud.delete_confirm') }}") == true) {
                        $.ajax({
                            url: delete_url,
                            type: 'DELETE',
                            success: function (result) {
                                // Show an alert with the result
                                new PNotify({
                                    title: "{{ trans('backpack::crud.delete_confirmation_title') }}",
                                    text: "{{ trans('backpack::crud.delete_confirmation_message') }}",
                                    type: "success"
                                });
                                // delete the row from the table
                                delete_button.parentsUntil('tr').parent().remove();

                                // Hide the modal, if any
                                $('.modal').modal('hide');
                            },
                            error: function (result) {
                                // Show an alert with the result
                                new PNotify({
                                    title: "{{ trans('backpack::crud.delete_confirmation_not_title') }}",
                                    text: "{{ trans('backpack::crud.delete_confirmation_not_message') }}",
                                    type: "warning"
                                });
                            }
                        });
                    } else {
                        new PNotify({
                            title: "{{ trans('backpack::crud.delete_confirmation_not_deleted_title') }}",
                            text: "{{ trans('backpack::crud.delete_confirmation_not_deleted_message') }}",
                            type: "info"
                        });
                    }
                });
            }

            function register_reset_activations_button_action() {
                $("[data-button-type=reset_activation]").unbind('click');
                // CRUD Action
                // ask for confirmation before deleting an item
                $("[data-button-type=reset_activation]").click(function (e) {
                    e.preventDefault();
                    var id = $(this).attr('data-id');
                    var reset_activations_button = $('#crudTable a[data-button-type="reset_activation"][data-id="'+id+'"]');
                    var action_url = $(this).attr('href');
                    var activations_used_container = reset_activations_button
                        .parentsUntil('tr')
                        .parent()
                        .find('.activations-used-value');
                    var sip_numbers_used_container = reset_activations_button.parentsUntil('tr').parent().find('.sip-numbers-used');

                    if (confirm("{{ trans('apartments.reset_confirm') }}") == true) {
                        $.ajax({
                            url: action_url,
                            type: 'GET',
                            success: function (result) {
                                if (activations_used_container.text() == 0) {
                                    new PNotify({
                                        title: "{{ trans('apartments.reset_confirmation_no_reset_title') }}",
                                        text: "{{ trans('apartments.reset_confirmation_no_reset_message') }}",
                                        type: "info"
                                    });

                                    return false;
                                } else {
                                    // Show an alert with the result
                                    new PNotify({
                                        title: "{{ trans('apartments.reset_confirmation_title') }}",
                                        text: "{{ trans('apartments.reset_confirmation_message') }}",
                                        type: "success"
                                    });
                                }

                                // delete the row from the table
                                activations_used_container.html(result.activations_used);
                                sip_numbers_used_container.find('span').each(function () {
                                    $(this).removeClass('sip-is-used');
                                    $(this).removeAttr('title');
                                });

                                // Hide the modal, if any
                                $('.modal').modal('hide');
                            },
                            error: function (result) {
                                // Show an alert with the result
                                if (result.status === 421) {
                                    new PNotify({
                                        text: "{{ trans('response_error.421') }}",
                                        type: "error",
                                        icon: false
                                    });
                                } else {
                                    new PNotify({
                                        title: "{{ trans('apartments.reset_confirmation_not_title') }}",
                                        text: "{{ trans('apartments.reset_confirmation_not_message') }}",
                                        type: "warning"
                                    });
                                }
                            }
                        });
                    } else {
                        new PNotify({
                            title: "{{ trans('apartments.reset_confirmation_not_reset_title') }}",
                            text: "{{ trans('apartments.reset_confirmation_not_reset_message') }}",
                            type: "info"
                        });
                    }
                });
            }

            @if ($crud->details_row)
            function register_details_row_button_action() {
                // var crudTable = $('#crudTable tbody');
                // Remove any previously registered event handlers from draw.dt event callback
                $('#crudTable tbody').off('click', 'td .details-row-button');

                // Make sure the ajaxDatatables rows also have the correct classes
                $('#crudTable tbody td .details-row-button').parent('td')
                    .removeClass('details-control').addClass('details-control')
                    .removeClass('text-center').addClass('text-center')
                    .removeClass('cursor-pointer').addClass('cursor-pointer');

                // Add event listener for opening and closing details
                $('#crudTable tbody td.details-control').on('click', function () {
                    var tr = $(this).closest('tr');
                    var btn = $(this).find('.details-row-button');
                    var row = table.row(tr);

                    if (row.child.isShown()) {
                        // This row is already open - close it
                        btn.removeClass('fa-minus-square-o').addClass('fa-plus-square-o');
                        $('div.table_row_slider', row.child()).slideUp(function () {
                            row.child.hide();
                            tr.removeClass('shown');
                        });
                    }
                    else {
                        // Open this row
                        btn.removeClass('fa-plus-square-o').addClass('fa-minus-square-o');
                        // Get the details with ajax
                        $.ajax({
                            url: '{{ url($crud->route) }}/' + btn.data('entry-id') + '/details',
                            type: 'GET',
                            // dataType: 'default: Intelligent Guess (Other values: xml, json, script, or html)',
                            // data: {param1: 'value1'},
                        })
                            .done(function (data) {
                                // console.log("-- success getting table extra details row with AJAX");
                                row.child("<div class='table_row_slider'>" + data + "</div>", 'no-padding').show();
                                tr.addClass('shown');
                                $('div.table_row_slider', row.child()).slideDown();
                                register_delete_button_action();
                                register_reset_activations_button_action();
                            })
                            .fail(function (data) {
                                // console.log("-- error getting table extra details row with AJAX");
                                row.child("<div class='table_row_slider'>{{ trans('backpack::crud.details_row_loading_error') }}</div>").show();
                                tr.addClass('shown');
                                $('div.table_row_slider', row.child()).slideDown();
                            })
                            .always(function (data) {
                                // console.log("-- complete getting table extra details row with AJAX");
                            });
                    }
                });
            }

            register_details_row_button_action();
            @endif

        });
    </script>
@endpush
