<ul class="house-tree-menu">
    @foreach ($tree as $entranceNumber => $entrance)
        <li class="{{ !empty($selected['entrance']) && $selected['entrance'] == $entranceNumber ? 'active' : '' }} col-width-200">
            <a href="#" class="treeview">
                <i class="fa fa-plus-square-o pull-left"></i>
                <i class="fa fa-minus-square-o pull-left"></i>
                <span>{{ $entrance['name'] }}</span>
                @if (!empty($badgeNotViewed['entrance'][$entranceNumber]))
                    <span class="badge badge-primary pull-right">@if ($badgeNotViewed['entrance'][$entranceNumber] >= 100)99+@else{{$badgeNotViewed['entrance'][$entranceNumber]}}@endif</span>
                @endif
            </a>
            <ul class="treeview-menu">
                @foreach ($entrance['items'] as $floorNumber => $floor)
                    <li class="{{ (!empty($selected['floor']) && !empty($selected['entrance']) && $selected['floor'] == $floorNumber && $selected['entrance'] == $entranceNumber) ? 'active' : '' }}">
                        <a href="#" class="treeview">
                            <i class="fa fa-plus-square-o pull-left"></i>
                            <i class="fa fa-minus-square-o pull-left"></i>
                            <span>{{ $floor['name'] }}</span>
                            @if (!empty($badgeNotViewed['floor'][$entranceNumber][$floorNumber]))
                                <span class="badge badge-primary pull-right">@if ($badgeNotViewed['floor'][$entranceNumber][$floorNumber] >= 100)99+@else{{$badgeNotViewed['floor'][$entranceNumber][$floorNumber]}}@endif</span>
                            @endif
                        </a>
                        <ul class="treeview-menu">
                            @foreach ($floor['items'] as $number => $apartment)

                                <li class="{{ !empty($selected['apartment']) && $selected['apartment'] == $apartment['number'] ? 'active' : '' }}">
                                    <a href="?apartment={{ $apartment['number'] }}&floor={{ $floorNumber }}&entrance={{ $entranceNumber }}">
                                        <span>{{ $apartment['name'] }}</span>
                                        @if (isset($badgeNotViewed['number'][$apartment['number']]))
                                            <span class="badge badge-primary pull-right">@if ($badgeNotViewed['number'][$apartment['number']] >= 100)99+@else{{$badgeNotViewed['number'][$apartment['number']]}}@endif</span>
                                        @endif
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endforeach
            </ul>
        </li>
    @endforeach
</ul>

@include('vendor.backpack.components.house-tree-menu.after_styles')