{{-- Show the inputs --}}
<?php
$cols = [];
$destinations = [];
foreach ($fields as $field) {
    if (empty($field['is_destination'])) {
        continue;
    }

    if (!empty($field['col'])) {
        $cols[$field['col']][] = $field;
    }
    else {
        $destinations[] = $field;
    }
}
?>
<script>
    window.destinationNotifications = {
        already_exists: {
            title: "{{ trans('destinations.already_exists') }}",
            type: "info"
        },
        empty: {
            title: "{{ trans('destinations.empty') }}",
            type: "info"
        }
    };
</script>
<div class="destinations-component">
@foreach ($destinations as $field)
    <!-- load the view from the application if it exists, otherwise load the one in the package -->
        @if(view()->exists('vendor.backpack.crud.fields.'.$field['type']))
            @include('vendor.backpack.crud.fields.'.$field['type'], array('field' => $field))
        @else
            @include('crud::fields.'.$field['type'], array('field' => $field))
        @endif
    @endforeach
    @foreach ($cols as $fields)
        <div class="col-md-6 col-hr">
            <hr>
        </div>
        <div class="col-md-6 destinations-col" @if($action === 'edit')style="display: none;"@endif>
        @foreach ($fields as $field)
            <!-- load the view from the application if it exists, otherwise load the one in the package -->
                @if(view()->exists('vendor.backpack.crud.fields.'.$field['type']))
                    @include('vendor.backpack.crud.fields.'.$field['type'], array('field' => $field))
                @else
                    @include('crud::fields.'.$field['type'], array('field' => $field))
                @endif
            @endforeach
        </div>
    @endforeach
    <div class="col-md-6 col-hr">
        <hr>
    </div>
</div>