<?php
function tree_element($entry, $key, $categories, $crud, $selected_entry = null) {
    if (!isset($entry->tree_element_shown)) {
        // mark the element as shown
        $categories[$key]->tree_element_shown = true;
        $entry->tree_element_shown = true;

        // see if this element has any children
        $children = [];
        foreach ($categories as $key => $subentry) {
            if ($subentry->parent_id == $entry->getKey()) {
                $children[] = $subentry;
            }
        }

        $children = collect($children)->sortBy('lft');

        $isParent = count($children);

        // show the tree element
        echo '<li data-id="' . $entry->getKey() . '" data-name="' .$entry->name. '" class="'.($selected_entry == $entry->getKey()?'selected':'').'">';
        echo '<span class="' . ($isParent ? 'treeview' : '') . '">' . $entry->name;
        if ($isParent) {
            echo '<i class="fa fa-caret-down pull-left"></i><i class="fa fa-caret-up pull-left"></i>';
        }
        echo '</span>';


        // if it does have children, show them
        if ($isParent) {
            echo '<ul class="treeview-menu">';
            foreach ($children as $key => $child) {
                $children[$key] = tree_element($child, $child->getKey(), $categories, $crud);
            }
            echo '</ul>';
        }
        echo '</li>';
    }

    return $entry;
}

?>
<div id="categories-picker" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">{{ trans('templates.categories.templates_categories') }}</h4>
            </div>
            <div class="modal-body">
                <ul class="sidebar-menu categories-tree">
                    <li>
                        <span class="treeview">
                            <i class="fa fa-caret-down pull-left"></i><i class="fa fa-caret-up pull-left"></i>
                            {{ trans('templates.categories.all_categories') }}
                        </span>
                        <ul class="treeview-menu">
                            <?php
                            $selected_category = (isset($entry->category_id))?:null;
                            $root_entries = $categories->filter(function ($item) {
                                return $item->parent_id == 0;
                            });
                            foreach ($root_entries as $key => $entry) {
                                $root_entries[$key] = tree_element($entry, $key, $categories, $crud, $selected_category);
                            }
                            ?>
                        </ul>
                    </li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left"
                        data-dismiss="modal">{{ trans('categories.buttons.cancel') }}</button>
                <button type="button"
                        class="btn btn-primary pull-right choose-category"
                        disabled="disabled">{{ trans('categories.buttons.choose') }}</button>
            </div>
        </div>
    </div>
</div>

@push('after_scripts')
    <script>
        $(document).ready(function() {
            $('.categories-tree .treeview:first-child').click(function (e) {
                e.stopPropagation();
                var $li = $(this).parent();
                if ($li.hasClass('active')) {
                    $li.removeClass('active');
                    $li.children('ul.treeview-menu').slideUp(200);
                }
                else {
                    $li.addClass('active');
                    $li.children('ul.treeview-menu').slideDown(200);
                }
            });
        });
    </script>
@endpush