@if (Auth::check())
    @php
        $notices = \App\Models\Notice::where('object_id', [config('app.object.id')])
            ->whereRaw('CURDATE() >= actual_from_date')
            ->whereRaw('CURDATE() <= actual_to_date')
            ->get()->count();

        $reviews = \App\Models\Review::where('object_id', [config('app.object.id')])
            ->whereRaw('answer IS NULL')
            ->get()->count();

        $announcements = \App\Models\Advert::where('object_id', [config('app.object.id')])
            ->whereRaw('CURDATE() >= actual_from_date')
            ->whereRaw('CURDATE() <= actual_to_date')
            ->get()->count();

        $quizzes = \App\Models\Quiz::where('object_id', [config('app.object.id')])
            ->where('is_filled', 0)
            ->whereRaw('start_at <= NOW()')
            ->whereRaw('end_at > NOW()')
            ->get()->count();


        $user = Auth::user();

        $claims = [];
        $raw_claims = null;

        $query = \App\Models\Claim::selectRaw('status, COUNT(id) AS count')
                ->whereIn('status', [0,1])
                ->where('object_id', [config('app.object.id')])
                ->groupBy('status');

        // if user have full access
        if ($user->can(\App\Models\PermissionManager\Permission::FULL_ACCESS) || $user->can(\App\Models\PermissionManager\Permission::CLAIMS_ALL_ACCESS)) {
            $raw_claims = $query->get();
        // if user have only type access
        } elseif ($user->can(\App\Models\PermissionManager\Permission::CLAIMS_BY_TYPE_ACCESS)) {
            $raw_claims = $query->whereIn('type_id', $user->claimsTypes->pluck('claim_type_id')->toArray())->get();
        }

        if($raw_claims) {
            $claims = $raw_claims->pluck('count', 'status')->toArray();
        }
    @endphp

    <!-- Left side column. contains the sidebar -->
    <aside class="main-sidebar">
        <div class="logo">
            <a href="{{ url(config('backpack.base.route_prefix', 'admin')) }}">
                <!-- mini logo for sidebar mini 50x50 pixels -->
                <span class="logo-mini">{!! config('backpack.base.logo_mini') !!}</span>
                <!-- logo for regular state and mobile devices -->
                <span class="logo-lg">{!! config('backpack.base.logo_lg') !!}</span>
            </a>
        </div>

        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">

            <!-- sidebar menu: : style can be found in sidebar.less -->
            <ul class="sidebar-menu">
                <!-- ================================================ -->
                <!-- ==== Recommended place for admin menu items ==== -->
                <!-- ================================================ -->
                <li class="treeview">
                    <a href="/admin"><i class="fa fa-dashboard"></i>
                        <span>{{ trans('backpack::base.dashboard') }}</span> <i class="fa fa-angle-left pull-right"></i></a>
                    <ul class="treeview-menu">
                        @can(\App\Models\PermissionManager\Permission::FULL_ACCESS)
                            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/objects') }}"><i
                                            class="fa fa-building-o"></i> <span>{{ trans('objects.menu') }}</span></a>
                            </li>
                        @endcan

                            @if(Auth::user()->can(\App\Models\PermissionManager\Permission::APARTMENTS_VIEW_FULL_ACCESS) || Auth::user()->can(\App\Models\PermissionManager\Permission::APARTMENTS_VIEW_LIMITED_ACCESS))
                                <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/apartment') }}"><i
                                                class="fa fa-hotel"></i>
                                        <span>{{ trans('apartments.apartments') }}</span></a></li>
                            @endif

                        @if((\App\Helpers\Objects::isEmpty()))
                                <li>
                                    <a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/user') }}">
                                        <i class="fa fa-user-o"></i>
                                        <span>{{ trans('backpack::permissionmanager.users') }}</span>
                                    </a>
                                </li>
                        @endif

                        @if(!(\App\Helpers\Objects::isEmpty()))

                            @if(Auth::user()->can(\App\Models\PermissionManager\Permission::CAMERAS_EDIT_ACCESS) || Auth::user()->can(\App\Models\PermissionManager\Permission::CAMERAS_VIEW_LIMITED_ACCESS))
                                <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/camera') }}"><i
                                                class="fa fa-video-camera"></i> <span>{{ trans('cameras.cameras') }}</span></a>
                                </li>
                            @endif
                            @if(Auth::user()->can(\App\Models\PermissionManager\Permission::CALLING_PANELS_EDIT_ACCESS) || Auth::user()->can(\App\Models\PermissionManager\Permission::CALLING_PANELS_VIEW_LIMITED_ACCESS))
                                <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/calling_panel') }}"><i
                                                class="fa fa-phone"></i>
                                        <span>{{ trans('calling_panels.calling_panels') }}</span></a></li>
                            @endif

                            @if (\App\Helpers\License::isFullLicense())
                                @if (Auth::user()->can(\App\Models\PermissionManager\Permission::CLAIM_TYPES_VIEW_ACCESS) || Auth::user()->can(\App\Models\PermissionManager\Permission::CLAIM_TYPES_FULL_ACCESS))
                                    <li>
                                        <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/claims/types') }}"><i
                                                    class="fa fa-list-alt"></i>
                                            <span>{{ trans('claims.claims_types') }}</span></a>
                                    </li>
                                @endif

                                @if(
                                    Auth::user()->can(\App\Models\PermissionManager\Permission::QUIZ_TEMPLATES_ACCESS)
                                    ||
                                    Auth::user()->can(\App\Models\PermissionManager\Permission::MESSAGE_TEMPLATES_ACCESS)
                                    ||
                                    Auth::user()->can(\App\Models\PermissionManager\Permission::QUIZ_TEMPLATES_ACCESS)
                                    ||
                                    Auth::user()->can(\App\Models\PermissionManager\Permission::MESSAGE_TEMPLATES_ACCESS)
                                    ||
                                    Auth::user()->can(\App\Models\PermissionManager\Permission::QUIZES_FULL_ACCESS)
                                    ||
                                    Auth::user()->can(\App\Models\PermissionManager\Permission::ANNOUNCEMENT_FULL_ACCESS)
                                )
                                    <li class="treeview">
                                        <a href="#"><i class="glyphicon glyphicon-duplicate"></i>
                                            <span>{{ trans('templates.templates') }}</span> <i
                                                    class="fa fa-angle-left pull-right"></i></a>
                                        <ul class="treeview-menu">
                                            @can(\App\Models\PermissionManager\Permission::QUIZ_TEMPLATES_ACCESS)
                                                <li>
                                                    <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/templates/quizzes') }}"><i
                                                                class="fa fa-check-square-o"></i>
                                                        <span>{{ trans('templates.for.polls') }}</span></a></li>
                                            @endcan

                                            @can(\App\Models\PermissionManager\Permission::MESSAGE_TEMPLATES_ACCESS)
                                                <li>
                                                    <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/templates/messages') }}"><i
                                                                class="fa fa-comment"></i>
                                                        <span>{{ trans('templates.for.messages') }}</span></a></li>
                                            @endcan

                                            @if(
                                                Auth::user()->can(\App\Models\PermissionManager\Permission::QUIZ_TEMPLATES_ACCESS)
                                                ||
                                                Auth::user()->can(\App\Models\PermissionManager\Permission::MESSAGE_TEMPLATES_ACCESS)
                                            )
                                                <li>
                                                    <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/templates/categories') }}"><i
                                                                class="glyphicon glyphicon-folder-open"></i>
                                                        <span>{{ trans('categories.categories') }}</span></a></li>
                                            @endif

                                            @if(
                                                Auth::user()->can(\App\Models\PermissionManager\Permission::QUIZES_FULL_ACCESS)
                                                ||
                                                Auth::user()->can(\App\Models\PermissionManager\Permission::ANNOUNCEMENT_FULL_ACCESS)
                                            )
                                                <li>
                                                    <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/templates/styles') }}"><i
                                                                class="glyphicon glyphicon-wrench"></i>
                                                        <span>{{ trans('styles.styles') }}</span></a></li>
                                            @endif
                                        </ul>
                                    </li>
                                @endif
                            @endif

                            @if(
                                Auth::user()->can(\App\Models\PermissionManager\Permission::USER_VIEW_FULL_ACCESS)
                                ||
                                Auth::user()->can(\App\Models\PermissionManager\Permission::USER_VIEW_LIMITED_ACCESS)
                                ||
                                Auth::user()->can(\App\Models\PermissionManager\Permission::ROLES_VIEW_ACCESS)
                                ||
                                Auth::user()->can(\App\Models\PermissionManager\Permission::PERMISSIONS_VIEW_ACCESS)
                                ||
                                Auth::user()->can(\App\Models\PermissionManager\Permission::AUTHORIZED_USERS_FULL_ACCESS)
                                ||
                                Auth::user()->can(\App\Models\PermissionManager\Permission::AUTHORIZED_USERS_LIMITED_ACCESS)
                            )
                        @endif
                            <!-- Users, Roles Permissions -->
                                <li class="treeview">
                                    <a href="#"><i class="fa fa-group"></i>
                                        <span>{{ trans('backpack::permissionmanager.user_rights') }}</span> <i
                                                class="fa fa-angle-left pull-right"></i></a>
                                    <ul class="treeview-menu">
                                        @if(
                                            Auth::user()->can(\App\Models\PermissionManager\Permission::USER_VIEW_FULL_ACCESS)
                                            ||
                                            Auth::user()->can(\App\Models\PermissionManager\Permission::USER_VIEW_LIMITED_ACCESS)
                                        )
                                            <li>
                                                <a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/user') }}"><i
                                                            class="fa fa-user-o"></i>
                                                    <span>{{ trans('backpack::permissionmanager.users') }}</span></a></li>
                                        @endif

                                        @if(
                                           Auth::user()->can(\App\Models\PermissionManager\Permission::AUTHORIZED_USERS_FULL_ACCESS)
                                           ||
                                           Auth::user()->can(\App\Models\PermissionManager\Permission::AUTHORIZED_USERS_LIMITED_ACCESS)
                                        )
                                            <li>
                                                <a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/active-users') }}"><i
                                                            class="fa fa-user"></i>
                                                    <span>{{ trans('active_users.crud.nav_string') }}</span></a></li>
                                        @endif

                                        @can(\App\Models\PermissionManager\Permission::ROLES_VIEW_ACCESS)
                                            <li>
                                                <a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/role') }}"><i
                                                            class="fa fa-group"></i>
                                                    <span>{{ trans('backpack::permissionmanager.roles') }}</span></a></li>
                                        @endcan

                                        @can(\App\Models\PermissionManager\Permission::PERMISSIONS_VIEW_ACCESS)
                                            <li>
                                                <a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/permission') }}"><i
                                                            class="fa fa-key"></i>
                                                    <span>{{ trans('backpack::permissionmanager.permissions') }}</span></a>
                                            </li>
                                        @endcan
                                    </ul>
                                </li>
                            @endif

                            @can(\App\Models\PermissionManager\Permission::SETTINGS_VIEW_ACCESS)
                                <li><a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/setting') }}"><i
                                                class="fa fa-cog" aria-hidden="true"></i>
                                        <span>{{ trans('settings.settings') }}</span></a></li>
                            @endcan
                            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin') . '/devteam') }}"><i
                                            class="fa fa-envelope-open-o" aria-hidden="true"></i>
                                    <span>{{ trans('devteam.feedback') }}</span></a></li>
                    </ul>
                </li>
                {{--<li class="treeview">--}}
                {{--<a href="#"><i class="fa fa-comment"></i> <span>{{ trans('adverts.messages') }}</span> <i class="fa fa-angle-left pull-right"></i></a>--}}
                {{--<ul class="treeview-menu">--}}
                {{--<li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/advert/create') }}"><i class="fa fa-sticky-note"></i> <span>{{ trans('adverts.adverts_menu') }}</span></a></li>--}}
                {{--<li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/notice/create') }}"><i class="fa fa-bell"></i> <span>{{ trans('notice.notice_menu') }}</span></a></li>--}}
                {{--</ul>--}}
                {{--</li>--}}

                @if(!(\App\Helpers\Objects::isEmpty()))
                    @if (\App\Helpers\License::isFullLicense())
                        @can(\App\Models\PermissionManager\Permission::ANNOUNCEMENT_FULL_ACCESS)
                            <li>
                                <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/announcement') }}"
                                   class="sidebar-link">
                                    <i class="fa fa-bullhorn"></i>
                                    <span>{{ trans('adverts.adverts_board') }}
                                        @if ($announcements)
                                            <span class="sidebar-badge">{{$announcements}}</span>
                                        @endif
                            </span>
                                </a>
                            </li>
                        @endcan

                        @can(\App\Models\PermissionManager\Permission::NOTIFICATIONS_FULL_ACCESS)
                            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/notice') }}"
                                   class="sidebar-link">
                                    <i class="fa fa-bell"></i>
                                    <span>{{ trans('notice.notice') }}
                                        @if ($notices)
                                            <span class="sidebar-badge">{{$notices}}</span></span>
                                    @endif
                                </a></li>
                        @endcan

                        @can(\App\Models\PermissionManager\Permission::REVIEWS_FULL_ACCESS)
                            @php $admin_review = filter_input(INPUT_COOKIE, 'admin/review'); @endphp
                            <li>
                                <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/review') }}@if($admin_review === 'false'){{'/group'}}@endif"
                                   class="sidebar-link">
                                    <i class="fa fa-comments"></i>
                                    <span>{{ trans('reviews.reviews') }}
                                        @if ($reviews)
                                            <span class="sidebar-badge">{{$reviews}}</span>
                                        @endif
                      </span>
                                </a></li>
                        @endcan

                        @can(\App\Models\PermissionManager\Permission::QUIZES_FULL_ACCESS)
                            {{--<li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/elfinder') }}"><i class="fa fa-files-o"></i> <span>{{ trans('backpack::crud.file_manager') }}</span></a></li>--}}
                            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/quizzes') }}"
                                   class="sidebar-link">
                                    <i class="fa fa-check-square-o"></i>
                                    <span>{{ trans('quizzes.quizzes') }}
                                        @if ($quizzes)
                                            <span class="sidebar-badge">{{$quizzes}}</span>
                                        @endif
                      </span>
                                </a></li>
                        @endcan

                        @if(
                          Auth::user()->can(\App\Models\PermissionManager\Permission::CLAIMS_ALL_ACCESS)
                          ||
                          Auth::user()->can(\App\Models\PermissionManager\Permission::CLAIMS_BY_TYPE_ACCESS)
                        )
                            @php $admin_claim = filter_input(INPUT_COOKIE, 'admin/claim'); @endphp
                            <li>
                                <a href="{{ url(config('backpack.base.route_prefix', 'admin').'/claims') }}@if($admin_claim === 'false'){{'/group'}}@endif"
                                   class="sidebar-link">
                                    <i class="icon icon-claims"></i>
                                    <span>{{ trans('claims.claims') }}
                                        @if ($claims)
                                            <span class="sidebar-badge">
                                    @if (isset($claims[0]))
                                                    {{$claims[0]}}
                                                @endif
                                                @if (isset($claims[0]) && isset($claims[1]))
                                                    /
                                                @endif
                                                @if (isset($claims[1]))
                                                    {{$claims[1]}}
                                                @endif
                                    </span>
                                        @endif
                      </span>
                                </a></li>
                        @endif
                    @endif
                @endif

                @if(Auth::user()->can(\App\Models\PermissionManager\Permission::FULL_ACCESS))
                    <li><a class="sidebar-link"
                           href="{{ url(config('backpack.base.route_prefix', 'admin') . '/updates') }}"><i
                                    class="fa fa-refresh"></i> <span>{{ trans('updater::updater.updates') }}
                                @if (
                                    (Cache::get('version') != null && Cache::get('version') > config('app.version'))
                                    || (Cache::get('test_version') != null && Cache::get('test_version') > config('app.version'))
                                    )
                                    <span class="sidebar-badge">
                                    1
                                </span>
                                @elseif(
                                    (Cache::get('version') != null && Cache::get('version') > config('app.version'))
                                    && (Cache::get('test_version') != null && Cache::get('test_version') > config('app.version'))
                                )
                                    <span class="sidebar-badge">
                                    2
                                </span>
                                @endif
                        </span>
                        </a>
                    </li>
                @endif



            </ul>
        </section>
        <!-- /.sidebar -->
    </aside>
@endif