@extends('backpack::layout')

@section('content')
    @php
        $acs = \Illuminate\Support\Facades\Request::get('acs');
        $email = \Illuminate\Support\Facades\Request::get('email');
    @endphp
    <div class="row">
        <div class="col-md-4 col-sm-6 col-md-offset-4 col-sm-offset-3">
            <div class="box box-default">
                {{--<div class="box-header with-border">--}}
                    {{--<div class="box-title">{{ trans('backpack::base.login') }}</div>--}}
                {{--</div>--}}
                <div class="box-body">
                    <div class="text-center" style="padding-bottom: 25px;">
                        <img src="{{ asset('logo.png') }}" alt="logo">
                    </div>
                    @if($acs === "true" || $acs === "false")
                    <div class="text-center" style="padding-bottom: 25px;">
                        @if($acs === "true")
                            {{trans('users.forms.login.acs')}}
                        @elseif($acs === "false")
                            {{trans('users.forms.login.no_acs')}}
                        @endif
                    </div>
                    @endif
                    <form class="form-horizontal" role="form" method="POST" action="{{ url(config('backpack.base.route_prefix').'/login') }}">
                        {!! csrf_field() !!}

                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            {{--<label class="col-md-4 control-label">{{ trans('backpack::base.email_address') }}</label>--}}
                            <div class="col-md-12">
                                <input type="email" class="form-control" name="email" value="@if(old('email')){{ old('email') }}@else{{$email}}@endif" placeholder="{{ trans('backpack::base.email_address') }}">

                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                            {{--<label class="col-md-4 control-label">{{ trans('backpack::base.password') }}</label>--}}

                            <div class="col-md-12">
                                <input type="password" class="form-control" name="password" placeholder="{{ trans('backpack::base.password') }}">

                                @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="remember"> {{ trans('backpack::base.remember_me') }}
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    {{ trans('backpack::base.login') }}
                                </button>

                                <a class="btn btn-link" href="{{ url(config('backpack.base.route_prefix', 'admin').'/password/reset') }}">{{ trans('backpack::base.forgot_your_password') }}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
