@extends('backpack::layout')

@section('content')
    <div class="error-403">
    <div class="container">
        <div class="content">
            <div class="title">403</div>
            <div class="quote">{{ trans('errors.errors.forbidden') }}</div>
            @if(isset($exception) && $exception->getMessage())
                <div class="explanation">
                    <br>
                    <small>{!! $exception->getMessage() !!}</small>
                </div>
            @endif
        </div>
    </div>
    </div>
@endsection

@section('after_styles')
    <link href="//fonts.googleapis.com/css?family=Lato:100" rel="stylesheet" type="text/css">

    <style>
        .error-403 {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            color: #B0BEC5;
            display: table;
            font-weight: 100;
            font-family: 'Lato';
            margin-top: 20vh;
        }

        .error-403 .container {
            text-align: center;
            display: table-cell;
            vertical-align: middle;
        }

        .error-403 .content {
            text-align: center;
            display: inline-block;
        }

        .error-403 .title {
            font-size: 156px;
        }

        .error-403 .quote {
            font-size: 36px;
        }

        .error-403 .explanation {
            font-size: 24px;
        }
    </style>
@endsection