@extends('backpack::layout')

@section('header')
	<section class="content-header">
	  <h1>{{ trans('devteam.feedback_title') }}</h1>
	</section>
@endsection

@section('content')
<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<form method="post"
			  action="{{ url('/admin/devteam/feedback') }}"
		>
			{!! csrf_field() !!}
			<div class="box">
				<div class="box-body">
					<div class="form-group {{ $errors->has('user_message') ? 'has-error' : '' }}">
						@include('crud::fields.textarea_custom',
						[ 'field' => [
								'label' => trans('devteam.message_label'),
								'name' => 'user_message',
								'placeholder' => trans("devteam.message_placeholder"),
								'class' => 'form-control'
							]
						])
						<span class="text-danger">{{ $errors->first('user_message') }}</span>
					</div>
				</div>
				<div class="box-footer">
					<button type="submit" class="btn btn-success pull-right">{{ trans('devteam.contact_us') }}</button>
				</div><!-- /.box-footer-->

			</div><!-- /.box -->
		</form>
	</div>
</div>

@endsection