<form method="post" action="{{ url('/admin/apartment-generation') }}" novalidate>
	{!! csrf_field() !!}
	<div class="row">
		<div class="col-md-6">
			<div class="form-group {{ $errors->has('number_entrances') ? 'has-error' : '' }}">
				<label>{{ trans('apartments.generation.number_entrances') }}</label>

				<input
						type="number"
						name="number_entrances"
						value="{{ $apartments_group_info['number_entrances'] }}"
						required
						autocomplete="off"
						class="form-control js-ap-generate-field"
						min="1"
				>
				<span class="text-danger">{{ $errors->first('number_entrances') }}</span>
			</div>
		</div>
		<div class="col-md-6">
			<div class="form-group {{ $errors->has('number_floors') ? 'has-error' : '' }}">
				<label>{{ trans('apartments.generation.number_floors') }}</label>
				<input
						type="number"
						name="number_floors"
						value="{{ $apartments_group_info['number_floors'] }}"
						required
						autocomplete="off"
						class="form-control js-ap-generate-field"
						min="1"
				>
				<span class="text-danger">{{ $errors->first('number_floors') }}</span>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-md-6">
			<div class="form-group {{ $errors->has('number_apartments_per_floors') ? 'has-error' : '' }}">
				<label>{{ trans('apartments.generation.number_apartments_per_floors') }}</label>
				<input
						type="number"
						name="number_apartments_per_floors"
						value="{{ $apartments_group_info['number_apartments_per_floors'] }}"
						required
						autocomplete="off"
						class="form-control js-ap-generate-field"
						min="1"
				>
				<span class="text-danger">{{ $errors->first('number_apartments_per_floors') }}</span>
			</div>
		</div>
		<div class="col-md-6">
			<div class="form-group {{ $errors->has('activation_limit') ? 'has-error' : '' }}">

				<label>{{ trans('apartments.generation.activation_limit') }}</label>
				<input
						type="number"
						name="activation_limit"
						value="{{ $apartments_group_info['activation_limit'] }}"
						required
						autocomplete="off"
						class="form-control js-ap-generate-field"
						min="0"
				>
				<span class="text-danger">{{ $errors->first('number_activations') }}</span>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12">
			<div class="gen-label">{{ trans('apartments.generation.total') }} <span id="maxActivationLimit">{{ $total_available_activations }}</span> (<span id="maxActivationPerApartment">-</span> {{ trans('apartments.generation.current_total') }})
			</div>

			<button type="submit" class="btn btn-success pull-right" id="generateButton">
				{{ trans('apartments.generation.generate') }}
			</button>
		</div>
	</div>
</form>