<form method="post" action="{{ url('/admin/apartment-generation-save') }}" id="apartmentsForm">
    {!! csrf_field() !!}

    <h2>{{ trans('objects.oblect') }}</h2>
    <table class="table dataTable" id="objectInfo">
        <tbody>
            @foreach($apartments_group_info as $info_group_key => $info_group_value)
            <tr>
                <td width="70%">{{ trans('apartments.generation.' . $info_group_key) }}</td>
                <td width="30%" class="text-right"><b class="js-{{ $info_group_key }}">{{ $info_group_value }}</b></td>
            </tr>
            @endforeach
            <tr>
                <td width="70%">{{ trans('apartments.crud_fields.activation_limit') }}</td>
                <td width="30%" class="text-right"><b class="js-total_available_activations">{{ $total_available_activations }}</b></td>
            </tr>
        </tbody>
    </table>

    @foreach($apartments as $entrance_number => $entrance)
        <table class="table dataTable bf-table entrance-group">
            <tbody>

                <tr class="ga-header">
                    <td colspan="5">
                        <h2>{{ $entrance_number }} {{ trans('apartments.crud_fields.entrance') }}</h2>
                    </td>
                </tr>
            </tbody>

                @foreach($entrance as $floor_number => $floor)
                    <tbody>
                        <tr class="ga-header">
                            <td colspan="5">
                                <h3>{{ $floor_number }} {{ trans('apartments.crud_fields.floor') }}</h3>
                            </td>
                        </tr>

                        @foreach($floor as $apartment)
                            <tr>
                                <td width="15%"><label>{{ trans('apartments.apartment') }} №</label></td>
                                <td width="30%">
                                    <div class="form-group {{ (!empty($apartments_duplicates_items[$apartment->id])) ? 'has-error' : '' }}">

                                        <?php
                                            $apartments_name_value = $apartment->number;

                                            if(!empty($edited_apartments[$entrance_number][$floor_number][$apartment->id]['number'])) {
                                                $apartments_name_value = $edited_apartments[$entrance_number][$floor_number][$apartment->id]['number'];
                                            }
                                        ?>
                                        <input
                                                type="text"
                                                name="apartments[{{ $entrance_number }}][{{ $floor_number }}][{{ $apartment->id }}][number]"
                                                value="{{ $apartments_name_value }}"
                                                class="form-control js-ap-name"
                                        >
                                    </div>
                                </td>

                                <td width="20%">
                                    <label>
                                        <b>{{ trans('apartments.crud_fields.activation_limit') }}:</b>
                                    </label>
                                </td>
                                <td width="25%">
                                    <div class="form-group">
                                        <input
                                                type="number"
                                                name="apartments[{{ $entrance_number }}][{{ $floor_number }}][{{$apartment->id }}][activation_limit]"
                                                value="{{ $apartment->activation_limit }}"
                                                class="form-control js-ap-activation-limit"
                                                min="0"
                                        >
                                    </div>
                                </td>
                                <td width="10%" class="text-right">
                                    <div class="buttons-stack-wrapper buttons-stack-line">
                                        <button type="button" class="btn btn-xs btn-default js-remove-apartment" data-id="{{ $apartment->id }}">
                                            <i class="fa fa-trash"></i>
                                            {{ trans('crud.delete') }}
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                @endforeach
            </tbody>
        </table>
    @endforeach

    <div class="row">
        <div class="col-xs-12">
            <input type="hidden" name="steps" value="0" class="steps">
            <button id="saveButton" type="submit" class="btn btn-success pull-right" @if(!empty($apartments_duplicates_items)) disabled @endif>
                {{ trans('crud.save') }}
            </button>
        </div>
    </div>
</form>