/*
*
* Templates picker
*
*/

jQuery(function ($) {

    'use strict';

    var $modal = $('#templates-picker');
    var $applyBtn = $modal.find('.btn-submit');
    var $backBtn = $modal.find('.btn-back');
    var $cancelBtn = $modal.find('.btn-cancel');

    $applyBtn.click(function () {
        $modal.modal('hide');
        $modal.trigger("templatePickerHide", [JSON.parse($('.sidebar-menu.tpl-list li.selected > input').val())]);
    });

    $('body').on('click', '.sidebar-menu.tpl-list li span', function (e) {
        e.stopPropagation();

        var $li = $(this).parent();
        if ($li.hasClass('selected')) {
            $li.removeClass('selected');
            $applyBtn.prop('disabled', 1);
        } else {
            $('.sidebar-menu.tpl-list li').removeClass('selected');
            $li.addClass('selected');
            $applyBtn.prop('disabled', 0);
        }
    });


    // ------------------ tree -------------------

    var $viewTpl = $('.picker-view-templates');
    var $viewTree = $('.picker-view-categories-tree');

    if ($viewTree.length) {
        $('.categories-tree .treeview i').click(function (e) {
            e.stopPropagation();
            var $li = $(this).parent().parent();
            if ($li.hasClass('active')) {
                $li.removeClass('active');
                $li.children('ul.treeview-menu').slideUp(200);
            }
            else {
                $li.addClass('active');
                $li.children('ul.treeview-menu').slideDown(200);
            }
        });

        $('.categories-tree span').click(function (e) {
            e.stopPropagation();
            var $li = $(this).parent();
            var $templates = $li.find('.templates-list > li');


            if (!$('#include-subfolder').is(':checked')) {
                $templates = $li.find('> .templates-list > li');
            }

            if (!$templates.length) {
                new PNotify(templatesPickerMessages.category_empty);
                return;
            }

            var html = '<ul class="sidebar-menu tpl-list">';
            $templates.each(function () {
                html += $(this).clone().wrap('<p>').parent().html();
            });
            html += '</ul>';

            $viewTree.hide();
            $viewTpl.html(html).show(300);

            $backBtn.show();
            $cancelBtn.hide();
        });

        $backBtn.click(function () {
            $viewTpl.hide();
            $backBtn.hide();
            $viewTree.show(300);
            $cancelBtn.show();
        });
    }

    // tags search
    if ($('.tags-view').length) {
        var $select = $('#tags-select');
        $select.select2({
            theme: "bootstrap"
        });

        $select.on('change', function () {
            var $value = $(this).val();
            $('.tpl-list li').each(function () {
                var $hide = true;
                var $tags = $(this).data('tags');
                if ($value) {
                    $.each($value, function () {
                        if ($tags.indexOf($(this).selector) != -1) {
                            $hide = false;
                        }
                    });
                } else {
                    $hide = false;
                }
                if(!$hide) {
                    $(this).removeClass('hidden');
                } else {
                    $(this).addClass('hidden');
                }
            })
        });
    }
});
