/*
*
* Backpack Crud / Form
*
*/

jQuery(function($){

    'use strict';


    /* Связать с квартирами */

    var $apartsGroups = $('.aparts-binding'),
        $apartsCheckbox = $('.aparts-binding-input'),
        $allApartments = $('.js-ac-all');

    checkAllChecked();

    $apartsGroups.each(function () {
        setCheckedCount($(this));
    });

    $apartsCheckbox.on('change', function () {
        setCheckedCount($(this).closest('.aparts-binding'));
        checkAllChecked();
    });


    $allApartments.on('click', function () {
        if($(this).is(':checked')) {
            toggleAllCheckboxex($apartsGroups);
        } else {
            toggleAllCheckboxex($apartsGroups, false);
        }
    });


    function setCheckedCount ($group) {
        if($group.length) {
            var $counter = $group.find('.aparts-binding-group-count'),
                $checked = $group.find('input:checked');

            if($counter.length) {
                $counter.text($checked.length);
            }
        }
    }

    function toggleAllCheckboxex($apartsGroups, check = true) {
        if($apartsGroups.length) {
            $apartsGroups.each(function () {
                $(this).find('.aparts-binding-input').each(function () {
                    if(check) {
                        setCheckboxChecked($(this));
                    } else {
                        checkboxRollBack($(this));
                    }
                });
                setCheckedCount($(this));
            });
        }
    }

    function setCheckboxChecked($checkbox) {
        if($checkbox.length) {
            var checked = $checkbox.is(':checked');
            $checkbox.attr('data-checked', +checked).prop('checked', true);
            $checkbox.closest('.checkbox').addClass('checkbox--state_disabled');
        }
    }

    function checkboxRollBack($checkbox) {
        if($checkbox.length) {
            var checked = $checkbox.attr('data-checked');

            if(parseInt(checked)) {
                $checkbox.prop('checked', true);
            } else {
                $checkbox.prop('checked', false);
            }
            $checkbox.closest('.checkbox').removeClass('checkbox--state_disabled');
        }
    }

    function checkAllChecked() {
        var $checkboxes = $('.aparts-binding input[type="checkbox"]'),
            allCheck = true;

        $checkboxes.each(function () {
            if(!$(this).is(':checked')) {
                allCheck = false;
            }
        });

        if(allCheck) {
            $('.js-ac-all').prop('checked', true);

            $checkboxes.each(function () {
                $(this).closest('.checkbox').addClass('checkbox--state_disabled');
            });

        } else {
            $('.js-ac-all').prop('checked', false);
            $checkboxes.each(function () {
                $(this).closest('.checkbox').removeClass('checkbox--state_disabled');
            });
        }

    }

    // Disabling form save buttons for preventing multiple submitting
    var $saveActions = $('#saveActions');
    if ($saveActions.length > 0) {
        var $form = $saveActions.closest('form');
        if ($form.length > 0) {
            $form.on('submit', function () {
                $saveActions.find('button').prop('disabled', true);
            });
        }
    }
});

