/*
*
* Categories picker
*
*/

jQuery(function ($) {

    'use strict';

    var $active = $('#field-category_id').val();
    if($active.length) {
        $('.chosen-category').html($('.categories-tree li[data-id="' + $active + '"]').data('name'));
    }

    var $applyBtn = $('.choose-category');

    $('.categories-tree span').click(function (e) {
        e.stopPropagation();
        var $li = $(this).parent();
        if (!$li.data('id')) {
            return;
        }
        if ($li.hasClass('selected')) {
            $li.removeClass('selected');
            $applyBtn.prop('disabled', 1);
        }
        else {
            $('.categories-tree li').removeClass('selected');
            $li.addClass('selected');
            $applyBtn.prop('disabled', 0);
        }
    });

    $('.categories-tree .treeview i').click(function (e) {
        e.stopPropagation();
        var $li = $(this).parent().parent();
        if ($li.hasClass('active')) {
            $li.removeClass('active');
            $li.children('ul.treeview-menu').slideUp(200);
        }
        else {
            $li.addClass('active');
            $li.children('ul.treeview-menu').slideDown(200);
        }
    });

    $applyBtn.click(function () {
        var $category = $('.categories-tree li.selected');
        $('.chosen-category').text($category.find('> span').text());
        $('#field-category_id').val($category.data('id'));
        $('#categories-picker').modal('hide');
    });
});
