@extends('backpack::layout')

@section('header')
    <section class="content-header">
        <h1>{{ trans('updater::updater.updates') }}</h1>
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12 error">
            @if(Cache::get('test_version'))
                <p class="text-success">{{ trans('updater::updater.test_aviable') }}!</p>
                <br>
            @endif
        </div>
        <div class="col-md-12 vers">
            {{ trans('updater::updater.current_version') }}: {{config('app.version')}}
        </div>
        <div class="col-md-12">
            @if(Cache::get('version'))
                {{ trans('updater::updater.last_version') }}: {{ Cache::get('version') }}
            @endif
        </div>
        <div class="col-md-12">
            @if(Cache::get('test_version'))
                {{ trans('updater::updater.test_version') }}: {{ Cache::get('test_version') }}
            @endif
        </div>
        <div class="col-md-12 bkp">
            @if($last_backup)
                 {{ trans('updater::updater.last_backup') }}: {{ $last_backup }}
            @else
                 {{ trans('updater::updater.no_backups') }}
            @endif
        </div>
        <div class="col-md-12">
            <br>
            @if(Cache::get('version') && Cache::get('version') > config('app.version'))
            <button class="update btn btn-primary ladda-button"><i
                        class="fa fa-refresh"></i> {{ trans('updater::updater.update') }}</button>
            @endif
            @if(Cache::get('test_version') && Cache::get('test_version') > config('app.version'))
                <button class="update-test btn btn-warning ladda-button"><i
                            class="fa fa-refresh"></i> {{ trans('updater::updater.update_test') }}</button>
            @endif
            <button class="backup btn btn-success ladda-button"><i
                        class="fa fa-save"></i> {{ trans('updater::updater.backup') }}</button>
        </div>
    </div>
    <div class="preloader hidden"><img src="{{ asset("/assets/preloader.gif") }}"></div>
@endsection

@section('after_styles')
    <style>
        .preloader {
            position: absolute;
            top: 0;
            bottom: 0;
            left:0;
            right:0;
            background: rgba(0,0,0,0.6);
            z-index: 5000;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
@endsection

@section('after_scripts')
    <script type="text/javascript">
      $(document).ready(function ($) {

        $('.backup').on('click', function (event) {
          event.preventDefault();
          var confirmation = '{{ trans('updater::updater.confirmation_backup') }}';
          if (confirm(confirmation)) {
            $('.preloader').removeClass('hidden');
            $.ajax({
              url: "/admin/backup",
              success: function (result) {
                $('.preloader').addClass('hidden');
                new PNotify({
                  title: '{{ trans('updater::updater.success') }}',
                  text: '{{ trans('updater::updater.created_backup') }}',
                  type: "success"
                });
                $('.bkp').html('{{ trans('updater::updater.last_backup') }}: ' + result.last_backup)
              },
              error: function (result) {
                $('.preloader').addClass('hidden');
                new PNotify({
                  title: '{{ trans('updater::updater.fail') }}',
                  text: '{{ trans('updater::updater.fail_backup') }}',
                  type: "warning"
                });
              }
            });
          }
        });

        $('.update-test').on('click', function (event) {
          event.preventDefault();
          var confirmation = '{{ trans('updater::updater.confirmation_update') }}';
          if (confirm(confirmation)) {
            $('.preloader').removeClass('hidden');
            $.ajax({
              url: "/admin/test-updates-install",
              success: function (result) {
                $('.preloader').addClass('hidden');
                new PNotify({
                  title: '{{ trans('updater::updater.success') }}',
                  text: '{{ trans('updater::updater.success_updates') }}',
                  type: "success"
                });
                $('.vers').html('{{ trans('updater::updater.current_version') }}: {{ Cache::get('test_version') }}');
                $('.update-test').addClass('hidden');
              },
              error: function (result) {
                $('.preloader').addClass('hidden');
                new PNotify({
                  title: '{{ trans('updater::updater.fail') }}',
                  text: '{{ trans('updater::updater.fail_updates') }}',
                  type: "warning"
                });
              }
            });
          }
        });

        $('.update').on('click', function (event) {
          event.preventDefault();
          var confirmation = '{{ trans('updater::updater.confirmation_update') }}';
          if (confirm(confirmation)) {
            $('.preloader').removeClass('hidden');
            $.ajax({
              url: "/admin/updates-install",
              success: function (result) {
                $('.preloader').addClass('hidden');
                new PNotify({
                  title: '{{ trans('updater::updater.success') }}',
                  text: '{{ trans('updater::updater.success_updates') }}',
                  type: "success"
                });
                $('.vers').html('{{ trans('updater::updater.current_version') }}: {{ Cache::get('version') }}');
                $('.update').addClass('hidden');
              },
              error: function (result) {
                $('.preloader').addClass('hidden');
                new PNotify({
                  title: '{{ trans('updater::updater.fail') }}',
                  text: '{{ trans('updater::updater.fail_updates') }}',
                  type: "warning"
                });
              }
            });
          }
        });

      });
    </script>
@endsection