@extends('installer::layout', [
    'title' => __('installer::license_key.step_title'),
    'showPreviousStepButton' => true,
    'previousStepName' => \evApps\Installer\app\Http\Utilities\Installer::REQUIREMENTS_STEP,
])

@php
$licenseKey = old('licenseKey') ? old('licenseKey') : env('APP_LICENSE_KEY');
@endphp

@section('content')
    <div class="form-group">
        <input type="text"
               name="licenseKey"
               required
               pattern=".{2,}"
               class="form-control"
               aria-describedby="licenseKeyHelp"
               value="{{ $licenseKey }}"
               autofocus>

        <small id="licenseKeyHelp" class="form-text text-muted">
            @lang('installer::license_key.license_key_help_text')
        </small>
    </div>
@endsection
