@extends('installer::layout', [
    'title' => __('installer::first_object.step_title'),
    'showPreviousStepButton' => true,
    'previousStepName' => \evApps\Installer\app\Http\Utilities\Installer::DATABASE_STEP,
])

@php
$firstObject = [
    'name' => old('name'),
    'address' => old('address'),
    'sip_server_address' => old('sip_server_address'),
    'sip_server_port' => old('sip_server_port'),
    'concierge_sip_number' => old('concierge_sip_number'),
];

if (
    empty($firstObject['name'])
    ||
    empty($firstObject['address'])
    ||
    empty($firstObject['sip_server_address'])
    ||
    empty($firstObject['sip_server_port'])
    ||
    empty($firstObject['concierge_sip_number'])
) {
    $stepData = \evApps\Installer\app\Http\Utilities\Installer::getStepData(
        \evApps\Installer\app\Http\Utilities\Installer::FIRST_OBJECT_STEP
    );

    if (!empty($stepData)) {
        if (empty($firstObject['name']) && isset($stepData['name'])) {
            $firstObject['name'] = $stepData['name'];
        }

        if (empty($firstObject['address']) && isset($stepData['address'])) {
            $firstObject['address'] = $stepData['address'];
        }

        if (empty($firstObject['sip_server_address']) && isset($stepData['sip_server_address'])) {
            $firstObject['sip_server_address'] = $stepData['sip_server_address'];
        }

        if (empty($firstObject['sip_server_port']) && isset($stepData['sip_server_port'])) {
            $firstObject['sip_server_port'] = $stepData['sip_server_port'];
        }

        if (empty($firstObject['concierge_sip_number']) && isset($stepData['concierge_sip_number'])) {
            $firstObject['concierge_sip_number'] = $stepData['concierge_sip_number'];
        }
    }
}
@endphp

@section('content')
    <div class="form-group">
        <label for="name">@lang('installer::first_object.name')</label>
        <input type="text"
               name="name"
               required
               class="form-control"
               id="name"
               value="{{ $firstObject['name'] }}">
    </div>

    <div class="form-group">
        <label for="address">@lang('installer::first_object.address')</label>
        <input type="text"
               name="address"
               required
               class="form-control"
               id="address"
               value="{{ $firstObject['address'] }}">
    </div>

    <div class="form-group">
        <label for="sip_server_address">@lang('installer::first_object.sip_server_address')</label>
        <input type="text"
               name="sip_server_address"
               required
               class="form-control"
               id="sip_server_address"
               value="{{ $firstObject['sip_server_address'] }}">
    </div>

    <div class="form-group">
        <label for="sip_server_port">@lang('installer::first_object.sip_server_port')</label>
        <input type="number"
               name="sip_server_port"
               class="form-control"
               id="sip_server_port"
               value="{{ $firstObject['sip_server_port'] }}">
    </div>

    <div class="form-group">
        <label for="concierge_sip_number">@lang('installer::first_object.concierge_sip_number')</label>
        <input type="number"
               name="concierge_sip_number"
               required
               class="form-control"
               id="concierge_sip_number"
               value="{{ $firstObject['concierge_sip_number'] }}">
    </div>
@endsection
