<?php

namespace evApps\Installer\app\Http\Controllers;

use evApps\Installer\app\Http\Requests\LicenseKeyRequest;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Redirect;

/**
 * Class LicenseKeyController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class LicenseKeyController extends Controller
{

    /**
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View|mixed
     */
    public function showStepForm()
    {
        return view('installer::steps.license_key');
    }

    /**
     * @param \evApps\Installer\app\Http\Requests\LicenseKeyRequest $request
     *
     * @return \Illuminate\Http\RedirectResponse
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function saveStepData(LicenseKeyRequest $request)
    {
        try {
            $result = Installer::checkLicenseKey($request->input('licenseKey'));
        } catch (\Exception $exception) {
            return Redirect::back()
                ->withErrors($exception->getMessage())
                ->withInput();
        }

        if ($result) {
            Installer::updateEnv([
                'APP_LICENSE_KEY' => $request->input('licenseKey'),
            ]);

            Installer::saveStepData(Installer::LICENSE_KEY_STEP, [
                'licenseKey' => $request->input('licenseKey'),
            ]);

            Installer::completeStep(Installer::LICENSE_KEY_STEP);

            return Redirect::route('evapps.installer.' . Installer::DATABASE_STEP . '-show-step-form');
        } else {
            return Redirect::back()
                ->withErrors(__('installer::license_key.license_key_not_valid'))
                ->withInput();
        }
    }
}
