<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingsTableSeeder extends Seeder
{

    protected $table = 'settings';

    /**
     * The settings to add.
     */
    protected $settings = [
        [
            'key' => 'company_name',
            'name' => 'Название компании',
            'description' => 'Название управляющей компании, которая выполняет обслуживание дома',
            'value' => 'УК "Этажи"',
            'field' => '{"name":"value","label":"Название компании","type":"text"}',
            'active' => 1,
        ],
        [
            'key' => 'active_locales',
            'name' => 'Активные языки',
            'description' => 'Список активных языков системы',
            'value' => 'ru, en',
            'field' => '{"name":"value","label":"Активные языки","type":"text"}',
            'active' => 1,
        ],
        [
            'key' => 'archival_time',
            'name' => 'Архивный период',
            'description' => 'Период вывода архивных уведомлений/объявлений',
            'value' => 3,
            'field' => '{"name":"value","label":"Архивный период (месяцев)","type":"number"}',
            'active' => 1,
        ],
        [
            'key'         => 'acs_users',
            'name'        => 'Разрешить служебный вход',
            'description' => 'Разрешить удаленное подключение для технической поддержки.',
            'value'       => 1,
            'field'       => '{"name":"value","label":"Разрешить удаленное подключение для технической поддержки.","type":"checkbox"}',
            'active'      => 1,
      ]
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table($this->table)->truncate();

        foreach ($this->settings as $index => $setting) {
            $result = DB::table($this->table)->insert($setting);

            if (!$result) {
                $this->command->info("Insert failed at record $index.");

                return;
            }
        }

        $this->command->info('Inserted ' . count($this->settings) . ' records.');
    }

    /**
     * @return mixed
     */
    public function getSettings()
    {
        return $this->settings;
    }
}
