<?php

use Illuminate\Database\Seeder;

class ReviewsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object_id = \App\Models\Building::first()->id;

        $reviews = [[
            'object_id' => $object_id,
            'text' => 'Благодарим за проделанную работу!',
            'apartment' => '9',
            'user_id' => 1,
            'is_viewed' => FALSE,
            'answer' => 'Пожалуйста',
        ],[
            'object_id' => $object_id,
            'text' => 'Спасибо',
            'apartment' => '8',
            'user_id' => 2,
            'is_viewed' => FALSE,
        ],[
            'object_id' => $object_id,
            'text' => 'Лифт работает как часы',
            'apartment' => '1',
            'user_id' => 3,
            'is_viewed' => TRUE,
        ],[
            'object_id' => $object_id,
            'text' => 'Спасибо за ремонт мусоропровода',
            'apartment' => '5',
            'user_id' => 5,
            'is_viewed' => FALSE,
        ]];

        $now = date('Y-m-d H:i:s');

        $timestamps = [
            'created_at' => $now,
            'updated_at' => $now,
        ];

        foreach ($reviews as $review) {
            DB::table('reviews')->insert(array_merge($review, $timestamps));
        }
    }
}
