<?php

use Illuminate\Database\Seeder;

class QuizTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object_id = \App\Models\Building::first()->id;
        $quizzes = [
            [
                'fields' => [
                    'object_id' => $object_id,
                    'title' => 'Работа лифта',
                    'question' => 'Устраивает ли вас работа нашего лифта?',
                    'free_answer' => true,
                    'start_at' => date('Y-m-d H:i:s'),
                    'end_at' => date('Y-m-d H:i:s', strtotime('+1 month')),
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ],
                'variants' => [
                    [
                        'text' => 'Да',
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ],
                    [
                        'text' => 'Нет',
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ],
                    [
                        'text' => 'Не уверен',
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ],
                ]
            ],
            [
                'fields' => [
                    'object_id' => $object_id,
                    'title' => 'Работа канализации',
                    'question' => 'А как вам канализация?',
                    'start_at' => date('Y-m-d H:i:s', strtotime('+2 month')),
                    'end_at' => date('Y-m-d H:i:s', strtotime('+6 month')),
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ],
                'variants' => [
                    [
                        'text' => 'Так себе',
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ],
                    [
                        'text' => 'Лучше всех',
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ],
                    [
                        'text' => 'Затрудняюсь',
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                    ],
                ]
            ],
        ];

        // let's create quiz
        foreach ($quizzes as $quiz) {
            $id = DB::table('quizzes')->insertGetId($quiz['fields']);
            $addition = [
                'quiz_id' => $id,
            ];
            foreach ($quiz['variants'] as $variant){
                DB::table('quiz_answer')->insert(array_merge($addition, $variant));
            }
        }
    }
}
