<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\PermissionManager\PermissionGroup;

class PermissionsGroupsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $groups = [
            [
                'id'    => PermissionGroup::FULL_ACCESS,
                'name'  => 'Полный доступ'
            ],
            [
                'id'    => PermissionGroup::USERS,
                'name'  => 'Пользователи'
            ],
            [
                'id'    => PermissionGroup::PERMISSIONS,
                'name'  => 'Права'
            ],
            [
                'id'    => PermissionGroup::ROLES,
                'name'  => 'Роли'
            ],
            [
                'id'    => PermissionGroup::APARTMENTS,
                'name'  => 'Квартиры'
            ],
            [
                'id'    => PermissionGroup::CAMERAS,
                'name'  => 'Камеры'
            ],
            [
                'id'    => PermissionGroup::CALLING_PANELS,
                'name'  => 'Вызывные панели'
            ],
            [
                'id'    => PermissionGroup::ANNOUNCEMENTS,
                'name'  => 'Доска объявлений'
            ],
            [
                'id'    => PermissionGroup::REVIEWS,
                'name'  => 'Отзывы'
            ],
            [
                'id'    => PermissionGroup::NOTIFICATIONS,
                'name'  => 'Уведомления'
            ],
            [
                'id'    => PermissionGroup::QUIZES,
                'name'  => 'Опросы'
            ],
            [
                'id'    => PermissionGroup::QUIZ_TEMPLATES,
                'name'  => 'Шаблоны опросов'
            ],
            [
                'id'    => PermissionGroup::MESSAGE_TEMPLATES,
                'name'  => 'Шаблоны сообщений'
            ],
            [
                'id'    => PermissionGroup::CLAIM_TYPES,
                'name'  => 'Типы заявок'
            ],
            [
                'id'    => PermissionGroup::CLAIMS,
                'name'  => 'Заявки'
            ],
            [
                'id'    => PermissionGroup::AUTHORIZED_USERS,
                'name'  => 'Активные пользователи'
            ],
            [
                'id'    => PermissionGroup::SETTINGS,
                'name'  => 'Настройки'
            ]
        ];

        foreach ($groups as $group) {
            DB::table('permissions_groups')->insert($group);
        }
    }
}
