<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;

class NoticeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object_id = \App\Models\Building::first()->id;
        $notice = [[
            'object_id' => $object_id,
            'theme' => 'Мусор',
            'text' => 'Просьба не оставлять мусор возле мусоропровода',
            'actual_from_date' => Carbon::parse('24-09-2017'),
            'actual_to_date' => Carbon::parse('24-09-2018'),
            'apartment' => '9',
        ],[
            'object_id' => $object_id,
            'theme' => 'Парковка',
            'text' => 'Просьба не оставлять автомобиль напротив входа в подъезд',
            'actual_from_date' => Carbon::parse('24-09-2017'),
            'actual_to_date' => Carbon::parse('24-09-2018'),
            'apartment' => '3',
        ]];

        $now = date('Y-m-d H:i:s');

        $timestamps = [
            'created_at' => $now,
            'updated_at' => $now,
        ];

        foreach ($notice as $item) {
            DB::table('notice')->insert(array_merge($item, $timestamps));
        }
    }
}
