<?php

use Illuminate\Database\Seeder;

class ClaimTypeTableSeeder extends Seeder
{
  /**
   * Run the database seeds.
   *
   * @return void
   */
  public function run()
  {
    $claim_types = [
      [
        'text' => 'Вызвать сантехника',
      ],
      [
        'text' => 'Вызвать электрика',
      ],
      [
        'text' => 'Вызвать плотника',
      ],
    ];

    $now = date('Y-m-d H:i:s');

    $timestamps = [
      'created_at' => $now,
      'updated_at' => $now,
    ];

    foreach ($claim_types as $claim_type) {
      DB::table('claim_type')->insert(array_merge($claim_type, $timestamps));
    }
  }
}
