<?php

use Illuminate\Database\Seeder;

class ApartmentsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object = \App\Models\Building::first()->id;
        $apartments = [[
            'number'          => 1,
            'entrance'        => 1,
            'floor'           => 1,
        ], [
            'number'          => 2,
            'entrance'        => 1,
            'floor'           => 1,
        ], [
            'number'          => 3,
            'entrance'        => 1,
            'floor'           => 1,
        ], [
            'number'          => 4,
            'entrance'        => 2,
            'floor'           => 1,
        ], [
            'number'          => 5,
            'entrance'        => 2,
            'floor'           => 1,
        ], [
            'number'          => 6,
            'entrance'        => 2,
            'floor'           => 1,
        ], [
            'number'          => 7,
            'entrance'        => 1,
            'floor'           => 2,
        ], [
            'number'          => 8,
            'entrance'        => 1,
            'floor'           => 2,
        ], [
            'number'          => 9,
            'entrance'        => 1,
            'floor'           => 2,
        ], [
            'number'          => 10,
            'entrance'        => 2,
            'floor'           => 2,
        ], [
            'number'          => 11,
            'entrance'        => 2,
            'floor'           => 2,
        ], [
            'number'          => 12,
            'entrance'        => 2,
            'floor'           => 2,
        ]];
        
        $length = 16;
        foreach ($apartments as &$apartment) {
            $apartment['activation_code'] = strtoupper(str_random($length));
        }
        unset($apartment);

        $now = date('Y-m-d H:i:s');

        $timestamps = [
            'created_at' => $now,
            'updated_at' => $now,
            'object_id' => $object
        ];

        // let's create apartments
        foreach ($apartments as $apartment) {
            DB::table('apartments')->insert(array_merge($apartment, $timestamps));
        }
    }
}
