<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;

class AdvertTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object = \App\Models\Building::first()->id;

        $adverts = [[
            'object_id' => $object,
            'theme' => 'Строительный мусор',
            'text' => 'Необходимо срочно убрать строительный мусор на площадке',
            'actual_from_date' => Carbon::parse('24-09-2017'),
            'actual_to_date' => Carbon::parse('24-09-2018'),
        ],[
            'object_id' => $object,
            'theme' => 'Отключение горячей воды',
            'text' => '24 сентября с 11:00 до 18:00 будет отключена подача горячей воды',
            'actual_from_date' => Carbon::parse('24-09-2017'),
            'actual_to_date' => Carbon::parse('24-09-2018'),
        ]];

        $now = date('Y-m-d H:i:s');

        $timestamps = [
            'created_at' => $now,
            'updated_at' => $now,
        ];

        foreach ($adverts as $advert) {
            DB::table('adverts')->insert(array_merge($advert, $timestamps));
        }
    }
}
