<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeyByApartmentIdInApartmentSipNumbersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->unsignedInteger('apartment_id')
                ->change();
        });

        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->foreign('apartment_id')
                ->references('id')->on('apartments')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->dropForeign(['apartment_id']);
        });

        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->integer('apartment_id')
                ->change();
        });
    }
}
