<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\Models\Device;
use App\Models\ApartmentSipNumber;

class AddForeignKeyForSipNumbersInDevicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop unique index
        Schema::table('devices', function (Blueprint $table) {
            $table->dropUnique('devices_sip_number_unique');
        });

        // Set sip number id's in return sip numbers
        foreach (Device::all() as $device) {
            $sip_number = ApartmentSipNumber::where('sip_number', $device->sip_number)
                ->where('apartment_id', $device->apartment_id)
                ->first();

            if ($sip_number instanceof ApartmentSipNumber) {
                $device->sip_number = $sip_number->id;
            } else {
                $device->sip_number = null;
            }

            $device->save();
        }

        DB::statement('ALTER TABLE `devices` CHANGE `sip_number` `sip_number_id` INT(11) UNSIGNED NULL');

        Schema::table('devices', function (Blueprint $table) {
           $table->foreign('sip_number_id')
            ->references('id')->on('apartment_sip_numbers')
            ->onDelete('SET NULL');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign key
        Schema::table('devices', function (Blueprint $table) {
            $table->dropForeign(['sip_number_id']);
        });

        $devices = Device::all();

        foreach ($devices as &$device) {
            $sip_number = ApartmentSipNumber::find($device->sip_number_id);

            if ($sip_number instanceof ApartmentSipNumber) {
                $device->sip_number = $sip_number->sip_number;
            } else {
                $device->sip_number = null;
            }
        }
        unset($device);

        // Change column
        DB::statement('ALTER TABLE `devices` CHANGE `sip_number_id` `sip_number` VARCHAR(255) NULL');

        foreach ($devices as $device) {
            $device->save();
        }

        // Set unique index
        Schema::table('devices', function (Blueprint $table) {
            $table->unique('sip_number');
        });

    }
}
