<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class UpdateSettingsTableSetTranslatableFields extends Migration
{
    const TABLE = 'settings';
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::table(self::TABLE)
            ->where('key', 'company_name')
            ->update([
                'name' => 'Company name',
                'description' => 'Name of the managing company',
                'field' => '{"name":"value","label":"Company name","type":"text"}'
            ]);

        DB::table(self::TABLE)
            ->where('key', 'active_locales')
            ->update([
                'name' => 'Languages',
                'description' => 'List of the system languages',
                'field' => '{"name":"value","label":"Languages","type":"text"}'
            ]);

        DB::table(self::TABLE)
            ->where('key', 'archival_time')
            ->update([
                'name' => 'Storage period',
                'description' => "The storage period for the messages/notifications in the user's mobile app",
                'field' => '{"name":"value","label":"Storage period (months)","type":"number"}'
            ]);

        DB::table(self::TABLE)
            ->where('key', 'acs_users')
            ->update([
                'name' => 'Access for technical support',
                'description' => "Remote control for technical support",
                'field' => '{"name":"value","label":"Remote control for technical support","type":"checkbox"}'
            ]);
    }

    /**
     * Reverse the migrations.
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::table(self::TABLE)
            ->where('key', 'company_name')
            ->update([
                'name' => 'Название компании',
                'description' => "Название управляющей компании, которая выполняет обслуживание дома",
                'field' => '{"name":"value","label":"Название компании","type":"text"}'
            ]);

        DB::table(self::TABLE)
            ->where('key', 'active_locales')
            ->update([
                'name' => 'Активные языки',
                'description' => 'Список активных языков системы',
                'field' => '{"name":"value","label":"Активные языки","type":"text"}'
            ]);

        DB::table(self::TABLE)
            ->where('key', 'archival_time')
            ->update([
                'name' => 'Архивный период',
                'description' => 'Период вывода архивных уведомлений/объявлений',
                'field' => '{"name":"value","label":"Архивный период (месяцев)","type":"number"}'
            ]);

        DB::table(self::TABLE)
            ->where('key', 'acs_users')
            ->update([
                'name'        => 'Разрешить служебный вход',
                'description' => 'Разрешить удаленное подключение для технической поддержки',
                'field'       => '{"name":"value","label":"Разрешить удаленное подключение для технической поддержки","type":"checkbox"}',
            ]);
    }
}
