<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\Models\PermissionManager\PermissionGroup;

class CreatePermissionsGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permissions_groups', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
        });

        $groups = [
            [
                'id'    => PermissionGroup::FULL_ACCESS,
                'name'  => 'Полный доступ'
            ],
            [
                'id'    => PermissionGroup::USERS,
                'name'  => 'Пользователи'
            ],
            [
                'id'    => PermissionGroup::PERMISSIONS,
                'name'  => 'Права'
            ],
            [
                'id'    => PermissionGroup::ROLES,
                'name'  => 'Роли'
            ],
            [
                'id'    => PermissionGroup::APARTMENTS,
                'name'  => 'Квартиры'
            ],
            [
                'id'    => PermissionGroup::CAMERAS,
                'name'  => 'Камеры'
            ],
            [
                'id'    => PermissionGroup::CALLING_PANELS,
                'name'  => 'Вызывные панели'
            ],
            [
                'id'    => PermissionGroup::ANNOUNCEMENTS,
                'name'  => 'Доска объявлений'
            ],
            [
                'id'    => PermissionGroup::REVIEWS,
                'name'  => 'Отзывы'
            ],
            [
                'id'    => PermissionGroup::NOTIFICATIONS,
                'name'  => 'Уведомления'
            ],
            [
                'id'    => PermissionGroup::QUIZES,
                'name'  => 'Опросы'
            ],
            [
                'id'    => PermissionGroup::QUIZ_TEMPLATES,
                'name'  => 'Шаблоны опросов'
            ],
            [
                'id'    => PermissionGroup::MESSAGE_TEMPLATES,
                'name'  => 'Шаблоны сообщений'
            ],
            [
                'id'    => PermissionGroup::CLAIM_TYPES,
                'name'  => 'Типы заявок'
            ],
            [
                'id'    => PermissionGroup::CLAIMS,
                'name'  => 'Заявки'
            ],
            [
                'id'    => PermissionGroup::AUTHORIZED_USERS,
                'name'  => 'Активные пользователи'
            ],
            [
                'id'    => PermissionGroup::SETTINGS,
                'name'  => 'Настройки'
            ]
        ];

        foreach ($groups as $group) {
            DB::table('permissions_groups')->insert($group);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permissions_groups');
    }
}
