<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\Models\PermissionManager\Permission;

class UpdateSettingsPermissionWeights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            Permission::findByName(Permission::SETTINGS_VIEW_ACCESS)->update([
                'weight' => Permission::SETTINGS_VIEW_ACCESS_WEIGHT,
            ]);

            Permission::findByName(Permission::SETTINGS_EDIT_ACCESS)->update([
                'weight' => Permission::SETTINGS_EDIT_ACCESS_WEIGHT,
            ]);
        } catch (Exception $exception) { }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        try {
            Permission::findByName(Permission::SETTINGS_VIEW_ACCESS)->update([
                'weight' => 10,
            ]);

            Permission::findByName(Permission::SETTINGS_EDIT_ACCESS)->update([
                'weight' => 5,
            ]);
        } catch (Exception $exception) { }
    }
}
