<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeObjectIdRowFromQuizzesTableSetNullable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('quizzes', function (Blueprint $table) {
            $table->unsignedInteger('object_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('quizzes', function (Blueprint $table) {
            $table->dropForeign('quizzes_object_id_foreign');
        });

        Schema::table('quizzes', function (Blueprint $table) {
            DB::delete('DELETE FROM quizzes WHERE object_id = NULL OR object_id = 0');

            $table->unsignedInteger('object_id')->nullable(false)->change();

            $table->foreign('object_id')->references('id')->on('objects');
        });
    }
}
