<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserClaimTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_claim_types', function (Blueprint $table) {
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('claim_type_id');

            $table
                ->foreign('user_id')->references('id')
                ->on('users')->onDelete('cascade');

            $table
                ->foreign('claim_type_id')->references('id')
                ->on('claim_type')->onDelete('cascade');

            $table->primary(['user_id', 'claim_type_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_claim_types');
    }
}
