<?php

use App\Models\PermissionManager\Permission;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddWeightFieldInPermissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table(config('laravel-permission.table_names.permissions'), function (Blueprint $table) {
            $table
                ->unsignedInteger('weight')
                ->default(0)
                ->after('name');
        });

        Permission::where('name', Permission::FULL_ACCESS)->update(['weight' => Permission::FULL_ACCESS_WEIGHT]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table(config('laravel-permission.table_names.permissions'), function (Blueprint $table) {
            $table->dropColumn('weight');
        });
    }
}
